/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.healthcheck;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheck;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckResponseValidator;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.util.clock.Clock;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportHealthCheck
implements HealthCheck {
    private static final Logger _log = LoggerFactory.getLogger(TransportHealthCheck.class);
    private final Clock _clock;
    private final TransportClient _clientToCheck;
    private final RestRequest _restRequest;
    private final Supplier<RequestContext> _requestContextSupplier;
    private final Supplier<Map<String, String>> _wireAttrsSupplier;
    private final HealthCheckResponseValidator _healthCheckResponseValidator;
    long _responseTimeThreshold;

    @Deprecated
    public TransportHealthCheck(Clock clock, TransportClient client, RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, HealthCheckResponseValidator healthCheckResponseValidator, long threshold) {
        this(clock, client, request, () -> requestContext, () -> wireAttrs, healthCheckResponseValidator, threshold);
    }

    public TransportHealthCheck(Clock clock, TransportClient client, RestRequest request, Supplier<RequestContext> requestContextSupplier, Supplier<Map<String, String>> wireAttrsSupplier, HealthCheckResponseValidator healthCheckResponseValidator, long threshold) {
        this._clock = clock;
        this._clientToCheck = client;
        this._restRequest = request;
        this._requestContextSupplier = requestContextSupplier;
        this._wireAttrsSupplier = wireAttrsSupplier;
        this._healthCheckResponseValidator = healthCheckResponseValidator;
        this._responseTimeThreshold = threshold;
    }

    @Override
    public void checkHealth(Callback<None> callback) {
        long startTime = this._clock.currentTimeMillis();
        TransportCallback transportCallback = response -> {
            long delay = this._clock.currentTimeMillis() - startTime;
            if (response.hasError()) {
                _log.debug("checkHealth: error response for request ({}): {}", (Object)this._restRequest.getURI(), (Object)response.getError());
                callback.onError((Throwable)new Exception("Error from " + this._restRequest.getURI() + " : " + response.getError()));
            } else if (delay > this._responseTimeThreshold) {
                _log.debug("checkHealth: return delay ({}ms) longer than threshold for request {}", (Object)delay, (Object)this._restRequest.getURI());
                callback.onError((Throwable)new TimeoutException("HealthCheck Timeout: " + delay + "ms for " + this._restRequest.getURI()));
            } else if (!this._healthCheckResponseValidator.validateResponse((RestResponse)response.getResponse())) {
                _log.error("checkHealth: response validating error for request ({}): {}", (Object)this._restRequest.getURI(), (Object)response);
                callback.onError(new Throwable("HealthCheck Response Error"));
            } else {
                _log.debug("checkHealth successful for client {}", (Object)this._clientToCheck);
                callback.onSuccess((Object)None.none());
            }
        };
        this._clientToCheck.restRequest(this._restRequest, this._requestContextSupplier.get(), this._wireAttrsSupplier.get(), transportCallback);
    }

    public RequestContext getRequestContext() {
        return this._requestContextSupplier.get();
    }

    public RestRequest getRestRequest() {
        return this._restRequest;
    }
}

