/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.partitions;

import com.linkedin.d2.balancer.properties.HashBasedPartitionProperties;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.MD5Hash;
import com.linkedin.d2.balancer.util.hashing.XXHash;
import com.linkedin.d2.balancer.util.partitions.AbstractPartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessException;

public class HashBasedPartitionAccessor
extends AbstractPartitionAccessor {
    private final HashBasedPartitionProperties _properties;
    private final HashFunction<String[]> _hashFunction;

    public HashBasedPartitionAccessor(HashBasedPartitionProperties properties) {
        super(properties.getPartitionKeyRegex(), properties.getPartitionCount() - 1);
        this._properties = properties;
        HashBasedPartitionProperties.HashAlgorithm hashAlgorithm = this._properties.getHashAlgorithm();
        switch (hashAlgorithm) {
            case MODULO: {
                this._hashFunction = new ModuloHash();
                break;
            }
            case MD5: {
                this._hashFunction = new MD5Hash();
                break;
            }
            case XXHASH: {
                this._hashFunction = new XXHash();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported hash algorithm: " + (Object)((Object)hashAlgorithm));
            }
        }
    }

    @Override
    public int getPartitionId(String key) throws PartitionAccessException {
        try {
            long longKey = this._hashFunction.hashLong(new String[]{key});
            return Math.abs((int)(longKey % (long)this._properties.getPartitionCount()));
        }
        catch (Exception ex) {
            throw new PartitionAccessException("Failed to getPartitionId for algorithm = '" + this._properties.getHashAlgorithm().toString() + "', key = '" + key + "', partitionCount = '" + this._properties.getPartitionCount() + "' ", ex);
        }
    }

    private static class ModuloHash
    implements HashFunction<String[]> {
        private ModuloHash() {
        }

        @Override
        public int hash(String[] key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long hashLong(String[] key) {
            try {
                return Long.parseLong(key[0]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Using MODULO hash function. Keys should be long values, but failed to parse key to long: " + key[0], ex);
            }
        }
    }
}

