/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.partitions;

import com.linkedin.d2.balancer.properties.CustomizedPartitionProperties;
import com.linkedin.d2.balancer.properties.HashBasedPartitionProperties;
import com.linkedin.d2.balancer.properties.PartitionProperties;
import com.linkedin.d2.balancer.properties.RangeBasedPartitionProperties;
import com.linkedin.d2.balancer.util.partitions.BasePartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.CustomizedPartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.DefaultPartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.HashBasedPartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessorRegistry;
import com.linkedin.d2.balancer.util.partitions.RangeBasedPartitionAccessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionAccessorFactory {
    private static final Logger _log = LoggerFactory.getLogger(PartitionAccessorFactory.class);

    public static PartitionAccessor getPartitionAccessor(String clusterName, PartitionAccessorRegistry availablePartitionAccessorRegistry, PartitionProperties properties) {
        switch (properties.getPartitionType()) {
            case RANGE: {
                return new RangeBasedPartitionAccessor((RangeBasedPartitionProperties)properties);
            }
            case HASH: {
                return new HashBasedPartitionAccessor((HashBasedPartitionProperties)properties);
            }
            case CUSTOM: {
                return PartitionAccessorFactory.buildCustomizedPartitionAccessor(clusterName, availablePartitionAccessorRegistry, (CustomizedPartitionProperties)properties);
            }
            case NONE: {
                return DefaultPartitionAccessor.getInstance();
            }
        }
        throw new IllegalArgumentException("Unsupported partition properties type.");
    }

    private static PartitionAccessor buildCustomizedPartitionAccessor(String clusterName, PartitionAccessorRegistry registry, CustomizedPartitionProperties customizedProperties) {
        List<BasePartitionAccessor> partitionAccessors = registry.getPartitionAccessors(clusterName);
        if (partitionAccessors == null || partitionAccessors.isEmpty()) {
            _log.error("No Customized PartitionAccessor defined for cluster " + clusterName + ", fall back to defaultPartitionAccessor");
            return DefaultPartitionAccessor.getInstance();
        }
        List<String> requestedClassList = customizedProperties.getPartitionAccessorList();
        if (requestedClassList == null || requestedClassList.isEmpty()) {
            BasePartitionAccessor partitionAccessor = partitionAccessors.get(0);
            _log.info("Use customized partitionAccessor for cluster:" + clusterName + ", class: " + partitionAccessor.getClass().getSimpleName() + " (out of " + partitionAccessors.size() + ") registration");
            return new CustomizedPartitionAccessor(customizedProperties, partitionAccessor);
        }
        for (String className : requestedClassList) {
            for (BasePartitionAccessor accessor : partitionAccessors) {
                if (!className.equals(accessor.getClass().getSimpleName())) continue;
                _log.info("Use matched partitionAccessor for cluster: " + clusterName + ", class: " + accessor.getClass().getSimpleName());
                return new CustomizedPartitionAccessor(customizedProperties, accessor);
            }
        }
        _log.error("None of the registered PartitionAccessor matches PartitionAccessorList defined for cluster " + clusterName + ", fall back to defaultPartitionAccessor");
        return DefaultPartitionAccessor.getInstance();
    }
}

