/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.partitions;

import com.linkedin.d2.balancer.util.partitions.BasePartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessorRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionAccessorRegistryImpl
implements PartitionAccessorRegistry {
    private static final Logger _log = LoggerFactory.getLogger((String)PartitionAccessorRegistryImpl.class.getName());
    private final Map<String, List<BasePartitionAccessor>> _partitionAccessors = new ConcurrentHashMap<String, List<BasePartitionAccessor>>();

    @Override
    public void register(String clusterName, BasePartitionAccessor accessor) {
        List accessors = this._partitionAccessors.computeIfAbsent(clusterName, k -> Collections.synchronizedList(new ArrayList()));
        accessors.add(accessor);
        _log.info("Register partitionAccessor for cluster: {} class: {} (total {})", new Object[]{clusterName, accessor.getClass().getSimpleName(), accessors.size()});
    }

    @Override
    public List<BasePartitionAccessor> getPartitionAccessors(String clusterName) {
        return this._partitionAccessors.get(clusterName);
    }
}

