/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.zkfs;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.MultiCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.Directory;
import com.linkedin.d2.balancer.KeyMapper;
import com.linkedin.d2.balancer.LoadBalancerWithFacilities;
import com.linkedin.d2.balancer.WarmUpService;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancer;
import com.linkedin.d2.balancer.util.ClusterInfoProvider;
import com.linkedin.d2.balancer.util.hashing.ConsistentHashKeyMapper;
import com.linkedin.d2.balancer.util.hashing.HashRingProvider;
import com.linkedin.d2.balancer.util.partitions.PartitionInfoProvider;
import com.linkedin.d2.balancer.zkfs.ZKFSDirectory;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.stores.zk.LastSeenZKStore;
import com.linkedin.d2.discovery.stores.zk.ZKPersistentConnection;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastSeenLoadBalancerWithFacilities
implements LoadBalancerWithFacilities,
WarmUpService {
    private static final Logger LOG = LoggerFactory.getLogger(LastSeenLoadBalancerWithFacilities.class);
    private final ZKFSDirectory _directory;
    private ZKPersistentConnection _zkPersistentConnection;
    private LastSeenZKStore<ClusterProperties> _lsClusterStore;
    private LastSeenZKStore<ServiceProperties> _lsServiceStore;
    private LastSeenZKStore<UriProperties> _lsUrisStore;
    private final SimpleLoadBalancer _loadBalancer;
    private final KeyMapper _keyMapper;

    public LastSeenLoadBalancerWithFacilities(SimpleLoadBalancer loadBalancer, String basePath, String d2ServicePath, final ZKPersistentConnection zkPersistentConnection, LastSeenZKStore<ClusterProperties> lsClusterStore, LastSeenZKStore<ServiceProperties> lsServiceStore, LastSeenZKStore<UriProperties> lsUrisStore) {
        this._loadBalancer = loadBalancer;
        this._directory = new ZKFSDirectory(basePath, d2ServicePath);
        this._zkPersistentConnection = zkPersistentConnection;
        this._lsClusterStore = lsClusterStore;
        this._lsServiceStore = lsServiceStore;
        this._lsUrisStore = lsUrisStore;
        this._keyMapper = new ConsistentHashKeyMapper(this._loadBalancer, this._loadBalancer);
        zkPersistentConnection.addListeners(Collections.singleton(new ZKPersistentConnection.EventListenerNotifiers(){

            @Override
            public void sessionEstablished(ZKPersistentConnection.Event event) {
                LastSeenLoadBalancerWithFacilities.this._directory.setConnection(zkPersistentConnection.getZKConnection());
            }
        }));
    }

    @Override
    public void start(Callback<None> callback) {
        try {
            this._zkPersistentConnection.start();
        }
        catch (IOException e) {
            LOG.error("Error in starting connection while starting load balancer. The connection be already started. The LoadBalancer will continue booting up", (Throwable)e);
        }
        MultiCallback multiCallback = new MultiCallback(callback, 4);
        this._lsClusterStore.start((Callback<None>)multiCallback);
        this._lsServiceStore.start((Callback<None>)multiCallback);
        this._lsUrisStore.start((Callback<None>)multiCallback);
        this._loadBalancer.start((Callback<None>)multiCallback);
    }

    @Override
    public void shutdown(final PropertyEventThread.PropertyEventShutdownCallback callback) {
        LOG.info("Shutting down");
        MultiCallback multiCallback = new MultiCallback((Callback)new Callback<None>(){

            public void onError(Throwable e) {
                callback.done();
            }

            public void onSuccess(None result) {
                callback.done();
            }
        }, 4);
        this._loadBalancer.shutdown(() -> multiCallback.onSuccess(None.none()));
        try {
            this._zkPersistentConnection.shutdown();
        }
        catch (InterruptedException e) {
            LOG.info("Error in shutting down connection while shutting down load balancer");
        }
        this._lsClusterStore.shutdown((Callback<None>)multiCallback);
        this._lsServiceStore.shutdown((Callback<None>)multiCallback);
        this._lsUrisStore.shutdown((Callback<None>)multiCallback);
    }

    @Override
    public void getClient(Request request, RequestContext requestContext, Callback<TransportClient> clientCallback) {
        this._loadBalancer.getClient(request, requestContext, clientCallback);
    }

    @Override
    public void getLoadBalancedServiceProperties(String serviceName, Callback<ServiceProperties> clientCallback) {
        this._loadBalancer.getLoadBalancedServiceProperties(serviceName, clientCallback);
    }

    @Override
    public Directory getDirectory() {
        return this._directory;
    }

    @Override
    public PartitionInfoProvider getPartitionInfoProvider() {
        return this._loadBalancer;
    }

    @Override
    public HashRingProvider getHashRingProvider() {
        return this._loadBalancer;
    }

    @Override
    public KeyMapper getKeyMapper() {
        return this._keyMapper;
    }

    @Override
    public TransportClientFactory getClientFactory(String scheme) {
        return this._loadBalancer.getClientFactory(scheme);
    }

    @Override
    public ClusterInfoProvider getClusterInfoProvider() {
        return this._loadBalancer;
    }

    @Override
    public void warmUpService(String serviceName, Callback<None> callback) {
        this._loadBalancer.warmUpService(serviceName, callback);
    }
}

