/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.zkfs;

import com.linkedin.common.callback.Callback;
import com.linkedin.d2.balancer.Directory;
import com.linkedin.d2.balancer.zkfs.ZKFSUtil;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZKFSDirectory
implements Directory {
    private final String _basePath;
    private final String _d2ServicePath;
    private volatile ZKConnection _connection;

    public ZKFSDirectory(String basePath) {
        this(basePath, "services");
    }

    public ZKFSDirectory(String basePath, String d2ServicePath) {
        this._basePath = basePath;
        this._d2ServicePath = d2ServicePath;
    }

    @Override
    public void getServiceNames(Callback<List<String>> callback) {
        ZooKeeper zk = this._connection.getZooKeeper();
        String path = ZKFSUtil.servicePath(this._basePath, this._d2ServicePath);
        zk.getChildren(path, false, (AsyncCallback.Children2Callback)new ChildrenCallback(callback), null);
    }

    @Override
    public void getClusterNames(Callback<List<String>> callback) {
        ZooKeeper zk = this._connection.getZooKeeper();
        String path = ZKFSUtil.clusterPath(this._basePath);
        zk.getChildren(path, false, (AsyncCallback.Children2Callback)new ChildrenCallback(callback), null);
    }

    public void setConnection(ZKConnection connection) {
        this._connection = connection;
    }

    class ChildrenCallback
    implements AsyncCallback.Children2Callback {
        private Callback<List<String>> _callback;

        ChildrenCallback(Callback<List<String>> callback) {
            this._callback = callback;
        }

        public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
            KeeperException.Code code = KeeperException.Code.get((int)rc);
            switch (code) {
                case OK: {
                    this._callback.onSuccess(children);
                    break;
                }
                case NONODE: {
                    this._callback.onSuccess(Collections.emptyList());
                    break;
                }
                default: {
                    this._callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                }
            }
        }
    }
}

