/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.zkfs;

public class ZKFSUtil {
    public static final String SERVICE_PATH = "services";
    public static final String CLUSTER_PATH = "clusters";
    public static final String URI_PATH = "uris";

    private ZKFSUtil() {
    }

    private static String normalizeBasePath(String basePath) {
        String normalized = basePath;
        while (normalized.endsWith("/")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        return normalized;
    }

    public static String servicePath(String basePath) {
        return ZKFSUtil.servicePath(basePath, SERVICE_PATH);
    }

    public static String servicePath(String basePath, String servicePath) {
        if (servicePath == null || servicePath.isEmpty()) {
            servicePath = SERVICE_PATH;
        }
        return String.format("%s/%s", ZKFSUtil.normalizeBasePath(basePath), servicePath);
    }

    public static String clusterPath(String basePath) {
        return String.format("%s/%s", ZKFSUtil.normalizeBasePath(basePath), CLUSTER_PATH);
    }

    public static String uriPath(String basePath) {
        return String.format("%s/%s", ZKFSUtil.normalizeBasePath(basePath), URI_PATH);
    }
}

