/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.event;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventSubscriber;
import com.linkedin.util.clock.SystemClock;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEventBusRequestsThrottler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyEventBusRequestsThrottler.class);
    public static final int DEFAULT_MAX_CONCURRENT_REQUESTS = 5;
    private final EventBusUpdaterSubscriber _eventBusUpdaterSubscriberSubscriber;
    private final PropertyEventBus<T> _eventBus;
    private final PropertyEventSubscriber<T> _externalSubscriber;
    private final List<String> _keysToFetch;
    private final boolean _logStatusEnabled;
    private final Map<String, Long> logTime = new ConcurrentHashMap<String, Long>();
    private final AtomicInteger _requestCompletedCount;
    private final AtomicInteger _requestStartedCount;
    private Callback<None> _callback;
    private final int _maxConcurrentRequests;

    public PropertyEventBusRequestsThrottler(PropertyEventBus<T> eventBus, PropertyEventSubscriber<T> externalSubscriber, List<String> keysToFetch, int maxConcurrentRequests, boolean logStatusEnabled) {
        this._eventBus = eventBus;
        this._externalSubscriber = externalSubscriber;
        this._keysToFetch = keysToFetch;
        this._logStatusEnabled = logStatusEnabled;
        this._eventBusUpdaterSubscriberSubscriber = new EventBusUpdaterSubscriber();
        this._maxConcurrentRequests = maxConcurrentRequests;
        this._requestStartedCount = new AtomicInteger(0);
        this._requestCompletedCount = new AtomicInteger(0);
    }

    public void sendRequests(Callback<None> callback) {
        LOG.info("Event Bus Requests throttler started for {} keys at a {} load rate", (Object)this._keysToFetch.size(), (Object)this._maxConcurrentRequests);
        if (this._keysToFetch.size() == 0) {
            callback.onSuccess((Object)None.none());
            return;
        }
        this._callback = callback;
        this.makeRequests(this._maxConcurrentRequests);
    }

    private void makeRequests(int n) {
        int initial = this._requestStartedCount.getAndAdd(n);
        if (this._keysToFetch.size() < initial) {
            return;
        }
        if (this._keysToFetch.size() < initial + n) {
            n = this._keysToFetch.size() - initial;
        }
        HashSet<String> keys = new HashSet<String>(this._keysToFetch.subList(initial, initial + n));
        if (this._logStatusEnabled || LOG.isDebugEnabled()) {
            LOG.debug("EventBus throttler fetching keys: {}", (Object)String.join((CharSequence)", ", keys));
        }
        for (String key : keys) {
            this.logTime.put(key, SystemClock.instance().currentTimeMillis());
        }
        this._eventBus.register(keys, this._externalSubscriber);
        this._eventBus.register(keys, this._eventBusUpdaterSubscriberSubscriber);
    }

    class EventBusUpdaterSubscriber
    implements PropertyEventSubscriber<T> {
        EventBusUpdaterSubscriber() {
        }

        void next(String prop) {
            int index = PropertyEventBusRequestsThrottler.this._requestCompletedCount.incrementAndGet();
            Long startTime = (Long)PropertyEventBusRequestsThrottler.this.logTime.get(prop);
            if (PropertyEventBusRequestsThrottler.this._logStatusEnabled || LOG.isDebugEnabled()) {
                LOG.info("{}/{} Key {} fetched in {}ms", new Object[]{index, PropertyEventBusRequestsThrottler.this._keysToFetch.size(), prop, SystemClock.instance().currentTimeMillis() - startTime});
            }
            if (PropertyEventBusRequestsThrottler.this._keysToFetch.size() == index) {
                PropertyEventBusRequestsThrottler.this._callback.onSuccess((Object)None.none());
                return;
            }
            PropertyEventBusRequestsThrottler.this.makeRequests(1);
        }

        @Override
        public void onInitialize(String propertyName, T propertyValue) {
            this.next(propertyName);
        }

        @Override
        public void onAdd(String propertyName, T propertyValue) {
            this.next(propertyName);
        }

        @Override
        public void onRemove(String propertyName) {
            this.next(propertyName);
        }
    }
}

