/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.file;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.util.FileSystemDirectory;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.event.PropertyEventSubscriber;
import com.linkedin.d2.discovery.stores.PropertyStore;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.d2.discovery.util.Stats;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStore<T>
implements PropertyStore<T>,
PropertyEventSubscriber<T> {
    private static final Logger _log = LoggerFactory.getLogger(FileStore.class);
    private static final String TMP_FILE_PREFIX = "d2-";
    private final String _fsPath;
    private final String _fsFileExtension;
    private final PropertySerializer<T> _serializer;
    private final Stats _getStats;
    private final Stats _putStats;
    private final Stats _removeStats;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    public FileStore(String fsPath, PropertySerializer<T> serializer) {
        this(fsPath, ".ini", serializer);
    }

    public FileStore(String fsPath, String fsFileExtension, PropertySerializer<T> serializer) {
        this._getStats = new Stats(60000L);
        this._putStats = new Stats(60000L);
        this._removeStats = new Stats(60000L);
        this._fsPath = fsPath;
        this._fsFileExtension = fsFileExtension;
        this._serializer = serializer;
        File file = new File(this._fsPath);
        if (!file.exists() && !file.mkdirs()) {
            LogUtil.error(_log, "unable to create file path: " + this._fsPath);
        }
    }

    @Override
    public void start(Callback<None> callback) {
        if (this.start()) {
            callback.onSuccess((Object)None.none());
        } else {
            callback.onError((Throwable)new IOException("unable to create file path: " + this._fsPath));
        }
    }

    public boolean start() {
        File file = new File(this._fsPath);
        this.w.lock();
        try {
            if (!file.exists() || !file.isDirectory()) {
                boolean bl = file.mkdirs();
                return bl;
            }
        }
        finally {
            this.w.unlock();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public T get(String listenTo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, T> getAll() {
        this.r.lock();
        try {
            List<String> propertyNames = FileSystemDirectory.getFileListWithoutExtension(this._fsPath);
            HashMap<String, T> result = new HashMap<String, T>();
            for (String propertyName : propertyNames) {
                T property = this.get(propertyName);
                if (property == null) continue;
                result.put(propertyName, property);
            }
            HashMap<String, T> hashMap = result;
            return hashMap;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String listenTo, T discoveryProperties) {
        this.w.lock();
        try {
            if (discoveryProperties == null) {
                LogUtil.warn(_log, "received a null property for resource ", listenTo, " received a null property");
            } else {
                this._putStats.inc();
                File file = this.getFile(listenTo);
                try {
                    file.createNewFile();
                    FileOutputStream outputStream = new FileOutputStream(file, false);
                    outputStream.write(this._serializer.toBytes(discoveryProperties));
                    outputStream.close();
                }
                catch (FileNotFoundException e) {
                    LogUtil.error(_log, "unable to find file on put: ", file);
                }
                catch (IOException e) {
                    LogUtil.error(_log, "unable to read file on put: ", file);
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void remove(String listenTo) {
        this.w.lock();
        try {
            this._removeStats.inc();
            File file = this.getFile(listenTo);
            if (file.exists()) {
                file.delete();
            } else {
                LogUtil.warn(_log, "file didn't exist on remove: ", file);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public boolean removeDirectory() {
        this.w.lock();
        try {
            boolean bl = FileStore.removeDirectory(this._fsPath);
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    public static boolean removeDirectory(String fsPath) {
        File file = new File(fsPath);
        try {
            FileUtils.deleteDirectory((File)file);
            return true;
        }
        catch (IOException e) {
            _log.info("Couldn't remove directory: " + fsPath, (Throwable)e);
            return false;
        }
    }

    @Override
    public void onAdd(String propertyName, T propertyValue) {
        this.put(propertyName, propertyValue);
    }

    @Override
    public void onInitialize(String propertyName, T propertyValue) {
        this.put(propertyName, propertyValue);
    }

    @Override
    public void onRemove(String propertyName) {
        this.remove(propertyName);
    }

    private File getFile(String listenTo) {
        return new File(this._fsPath + File.separatorChar + listenTo + this._fsFileExtension);
    }

    @Override
    public void shutdown(Callback<None> shutdown) {
        LogUtil.info(_log, "shutting down");
        shutdown.onSuccess((Object)None.none());
    }

    public String getPath() {
        return this._fsPath;
    }

    public PropertySerializer<T> getSerializer() {
        return this._serializer;
    }

    public long getGetCount() {
        return this._getStats.getCount();
    }

    public long getPutCount() {
        return this._putStats.getCount();
    }

    public long getRemoveCount() {
        return this._removeStats.getCount();
    }
}

