/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.toggling;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventPublisher;
import com.linkedin.d2.discovery.stores.PropertyStore;
import com.linkedin.d2.discovery.stores.util.NullEventBus;
import com.linkedin.d2.discovery.stores.util.StoreEventPublisher;
import java.util.concurrent.atomic.AtomicBoolean;

public class TogglingPublisher<T> {
    private final PublisherWithStatus<T> _primary;
    private final PublisherWithStatus<T> _backup;
    private final PropertyEventBus<T> _eventBus;
    private final PropertyEventBus<T> _nullBus = new NullEventBus();

    public TogglingPublisher(PropertyEventPublisher<T> primary, PropertyStore<T> backup, PropertyEventBus<T> eventBus) {
        this._primary = new PublisherWithStatus(primary);
        this._backup = new PublisherWithStatus(new StoreEventPublisher<T>(backup));
        this._eventBus = eventBus;
    }

    public PropertyEventBus<T> getEventBus() {
        return this._eventBus;
    }

    public void enablePrimary(Callback<None> callback) {
        this.configure(callback, this._primary, this._backup);
    }

    public void enableBackup(Callback<None> callback) {
        this.configure(callback, this._backup, this._primary);
    }

    private void configure(final Callback<None> callback, final PublisherWithStatus<T> activate, final PublisherWithStatus<T> deactivate) {
        activate.start(new Callback<None>(){

            public void onSuccess(None none) {
                PropertyEventPublisher pubActivate = activate.getPublisher();
                pubActivate.setBus(TogglingPublisher.this._eventBus);
                TogglingPublisher.this._eventBus.setPublisher(pubActivate);
                if (deactivate.started()) {
                    PropertyEventPublisher pubDeactivate = deactivate.getPublisher();
                    pubDeactivate.setBus(TogglingPublisher.this._nullBus);
                }
                callback.onSuccess((Object)None.none());
            }

            public void onError(Throwable e) {
                callback.onError(e);
            }
        });
    }

    public void shutdown(Callback<None> callback) {
        boolean primary = this._primary.started();
        boolean backup = this._backup.started();
        int count = (primary ? 1 : 0) + (backup ? 1 : 0);
        Callback multiCallback = Callbacks.countDown(callback, (int)count);
        if (primary) {
            this._primary.getPublisher().shutdown((Callback<None>)multiCallback);
        }
        if (backup) {
            this._backup.getPublisher().shutdown((Callback<None>)multiCallback);
        }
    }

    private class PublisherWithStatus<T> {
        private final PropertyEventPublisher<T> _publisher;
        private final AtomicBoolean _started = new AtomicBoolean(false);

        private PublisherWithStatus(PropertyEventPublisher<T> publisher) {
            this._publisher = publisher;
        }

        public void start(Callback<None> callback) {
            if (this._started.compareAndSet(false, true)) {
                this._publisher.start(callback);
            } else {
                callback.onSuccess((Object)None.none());
            }
        }

        public PropertyEventPublisher<T> getPublisher() {
            return this._publisher;
        }

        public boolean started() {
            return this._started.get();
        }
    }
}

