/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.util;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventPublisher;
import com.linkedin.d2.discovery.stores.PropertyStore;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreEventPublisher<T>
implements PropertyEventPublisher<T> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreEventPublisher.class);
    private final PropertyStore<T> _store;
    private PropertyEventBus<T> _eventBus;

    public StoreEventPublisher(PropertyStore<T> store) {
        this._store = store;
    }

    @Override
    public void setBus(PropertyEventBus<T> tPropertyEventBus) {
        this._eventBus = tPropertyEventBus;
    }

    @Override
    public void startPublishing(String prop) {
        try {
            this._eventBus.publishInitialize(prop, this._store.get(prop));
        }
        catch (PropertyStoreException e) {
            LOG.error("Failed to get property " + prop + " from underlying store", (Throwable)e);
            this._eventBus.publishInitialize(prop, null);
        }
    }

    @Override
    public void stopPublishing(String prop) {
    }

    @Override
    public void start(Callback<None> callback) {
        callback.onSuccess((Object)None.none());
    }

    @Override
    public void shutdown(Callback<None> callback) {
        this._store.shutdown(callback);
    }
}

