/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.util;

import com.linkedin.d2.discovery.event.PropertyEventSubscriber;
import com.linkedin.d2.discovery.stores.PropertyStore;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreEventSubscriber<T>
implements PropertyEventSubscriber<T> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreEventSubscriber.class);
    private final PropertyStore<T> _store;

    public StoreEventSubscriber(PropertyStore<T> store) {
        this._store = store;
    }

    @Override
    public void onInitialize(String propertyName, T propertyValue) {
        try {
            this._store.put(propertyName, propertyValue);
            LOG.debug("STORE EVENT SUBSCRIBER. OnInitialize. adding property to file store. propertyName:" + propertyName + " propertyValue:" + propertyValue);
        }
        catch (PropertyStoreException e) {
            LOG.error("Failed to write property " + propertyName + " to underlying store", (Throwable)e);
        }
    }

    @Override
    public void onAdd(String propertyName, T propertyValue) {
        try {
            this._store.put(propertyName, propertyValue);
        }
        catch (PropertyStoreException e) {
            LOG.error("Failed to write property " + propertyName + " to underlying store", (Throwable)e);
        }
    }

    @Override
    public void onRemove(String propertyName) {
        try {
            this._store.remove(propertyName);
        }
        catch (PropertyStoreException e) {
            LOG.error("Failed to remove property " + propertyName + " from underlying store", (Throwable)e);
        }
    }
}

