/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.d2.discovery.stores.zk.ZKConnectionBuilder;
import com.linkedin.d2.discovery.stores.zk.ZKPersistentConnection;
import com.linkedin.d2.discovery.stores.zk.ZkConnectionProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedZkConnectionProvider
implements ZkConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SharedZkConnectionProvider.class);
    private Map<ZKConnectionBuilder, ZKPersistentConnection> _sharedConnections = new HashMap<ZKConnectionBuilder, ZKPersistentConnection>();
    private LongAdder _requestCount = new LongAdder();
    private volatile boolean _sharingEnabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZKPersistentConnection getZKPersistentConnection(ZKConnectionBuilder zkConnectionBuilder) {
        ZKPersistentConnection connection;
        if (!this._sharingEnabled) {
            LOG.warn("Trying to obtain connections after application has been started!");
            return new ZKPersistentConnection(zkConnectionBuilder);
        }
        this._requestCount.increment();
        ZKConnectionBuilder builder = new ZKConnectionBuilder(zkConnectionBuilder);
        Map<ZKConnectionBuilder, ZKPersistentConnection> map = this._sharedConnections;
        synchronized (map) {
            if (this._sharedConnections.containsKey(builder)) {
                connection = this._sharedConnections.get(builder);
                if (connection.isConnectionStarted()) {
                    LOG.warn("There is a connection with the same parameters that are already started. Opening a new connection now. Please consider constructing connections before startup.");
                    return new ZKPersistentConnection(builder);
                }
            } else {
                connection = new ZKPersistentConnection(builder);
                this._sharedConnections.put(builder, connection);
            }
        }
        connection.incrementShareCount();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureConnectionClosed() throws InterruptedException {
        Map<ZKConnectionBuilder, ZKPersistentConnection> map = this._sharedConnections;
        synchronized (map) {
            Collection<ZKPersistentConnection> connectionList = this._sharedConnections.values();
            for (ZKPersistentConnection connection : connectionList) {
                if (connection.isConnectionStopped()) continue;
                connection.forceShutdown();
            }
        }
    }

    public void disableSharing() {
        this._sharingEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getZkConnectionCount() {
        Map<ZKConnectionBuilder, ZKPersistentConnection> map = this._sharedConnections;
        synchronized (map) {
            return this._sharedConnections.size();
        }
    }

    public int getRequestCount() {
        return this._requestCount.intValue();
    }
}

