/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import com.linkedin.util.ArgumentUtil;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public class ZKConnectionBuilder {
    private final String _connectString;
    private int _sessionTimeout;
    private boolean _shutdownAsynchronously = false;
    private int _retryLimit = 0;
    private boolean _isSymlinkAware = false;
    private boolean _exponentialBackoff = false;
    private ScheduledExecutorService _retryScheduler = null;
    private long _initInterval = 0L;
    private Function<ZooKeeper, ZooKeeper> _zkDecorator = null;
    private boolean _isWaitForConnected = false;

    public ZKConnectionBuilder(String connectString) {
        ArgumentUtil.notNull((Object)connectString, (String)"connectString");
        this._connectString = connectString;
    }

    public ZKConnectionBuilder(ZKConnectionBuilder builder) {
        this._connectString = builder._connectString;
        this._sessionTimeout = builder._sessionTimeout;
        this._shutdownAsynchronously = builder._shutdownAsynchronously;
        this._retryLimit = builder._retryLimit;
        this._isSymlinkAware = builder._isSymlinkAware;
        this._exponentialBackoff = builder._exponentialBackoff;
        this._retryScheduler = builder._retryScheduler;
        this._initInterval = builder._initInterval;
        this._zkDecorator = builder._zkDecorator;
        this._isWaitForConnected = builder._isWaitForConnected;
    }

    public ZKConnectionBuilder setTimeout(int sessionTimeout) {
        this._sessionTimeout = sessionTimeout;
        return this;
    }

    public ZKConnectionBuilder setShutdownAsynchronously(boolean shutdownAsynchronously) {
        this._shutdownAsynchronously = shutdownAsynchronously;
        return this;
    }

    public ZKConnectionBuilder setRetryLimit(int retryLimit) {
        this._retryLimit = retryLimit;
        return this;
    }

    public ZKConnectionBuilder setIsSymlinkAware(boolean isSymlinkAware) {
        this._isSymlinkAware = isSymlinkAware;
        return this;
    }

    public ZKConnectionBuilder setExponentialBackoff(boolean exponentialBackoff) {
        this._exponentialBackoff = exponentialBackoff;
        return this;
    }

    public ZKConnectionBuilder setScheduler(ScheduledExecutorService retryScheduler) {
        this._retryScheduler = retryScheduler;
        return this;
    }

    public ZKConnectionBuilder setInitInterval(long initInterval) {
        this._initInterval = initInterval;
        return this;
    }

    public ZKConnectionBuilder setZooKeeperDecorator(Function<ZooKeeper, ZooKeeper> zkDecorator) {
        this._zkDecorator = zkDecorator;
        return this;
    }

    public ZKConnectionBuilder setWaitForConnected(boolean waitForConnected) {
        this._isWaitForConnected = waitForConnected;
        return this;
    }

    public ZKConnection build() {
        return new ZKConnection(this._connectString, this._sessionTimeout, this._retryLimit, this._exponentialBackoff, this._retryScheduler, this._initInterval, this._shutdownAsynchronously, this._isSymlinkAware, this._zkDecorator, this._isWaitForConnected);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZKConnectionBuilder that = (ZKConnectionBuilder)o;
        return this._sessionTimeout == that._sessionTimeout && this._shutdownAsynchronously == that._shutdownAsynchronously && this._retryLimit == that._retryLimit && this._isSymlinkAware == that._isSymlinkAware && this._exponentialBackoff == that._exponentialBackoff && this._initInterval == that._initInterval && Objects.equals(this._connectString, that._connectString) && Objects.equals(this._retryScheduler, that._retryScheduler) && Objects.equals(this._zkDecorator, that._zkDecorator) && this._isWaitForConnected == that._isWaitForConnected;
    }

    public int hashCode() {
        return Objects.hash(this._connectString, this._sessionTimeout, this._shutdownAsynchronously, this._retryLimit, this._isSymlinkAware, this._exponentialBackoff, this._retryScheduler, this._initInterval, this._zkDecorator, this._isWaitForConnected);
    }
}

