/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZKConnectionBuilder;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKPersistentConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ZKPersistentConnection.class);
    private final Object _mutex = new Object();
    private final ZKConnectionBuilder _zkConnectionBuilder;
    private ZKConnection _zkConnection;
    private Set<EventListener> _listeners;
    private State _state = State.INIT;
    private AtomicInteger _activeUserCount;
    private AtomicInteger _registeredUserCount;
    private volatile boolean _hasForcefullyShutdown;

    public ZKPersistentConnection(String connect, int timeout, Collection<? extends EventListener> listeners) {
        this(connect, timeout, listeners, false);
    }

    public ZKPersistentConnection(String connect, int timeout, Collection<? extends EventListener> listeners, boolean shutdownAsynchronously) {
        this(connect, timeout, listeners, shutdownAsynchronously, false);
    }

    public ZKPersistentConnection(String connect, int timeout, Collection<? extends EventListener> listeners, boolean shutdownAsynchronously, boolean isSymlinkAware) {
        this(connect, timeout, listeners, shutdownAsynchronously, isSymlinkAware, false);
    }

    public ZKPersistentConnection(String connect, int timeout, Collection<? extends EventListener> listeners, boolean shutdownAsynchronously, boolean isSymlinkAware, boolean waitForConnected) {
        this(new ZKConnectionBuilder(connect).setTimeout(timeout).setShutdownAsynchronously(shutdownAsynchronously).setIsSymlinkAware(isSymlinkAware).setWaitForConnected(waitForConnected));
        this.addListeners(listeners);
    }

    public ZKPersistentConnection(ZKConnectionBuilder zkConnectionBuilder) {
        this._zkConnectionBuilder = zkConnectionBuilder;
        this._zkConnection = this._zkConnectionBuilder.build();
        this._zkConnection.addStateListener(new Listener());
        this._listeners = new HashSet<EventListener>();
        this._activeUserCount = new AtomicInteger(0);
        this._registeredUserCount = new AtomicInteger(0);
        this._hasForcefullyShutdown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListeners(Collection<? extends EventListener> listeners) {
        Object object = this._mutex;
        synchronized (object) {
            if (this._state != State.INIT) {
                throw new IllegalStateException("Listeners can be added only before connection starts, current state: " + (Object)((Object)this._state));
            }
            this._listeners.addAll(listeners);
        }
    }

    public void incrementShareCount() {
        this._registeredUserCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        Object object = this._mutex;
        synchronized (object) {
            this._activeUserCount.getAndIncrement();
            if (this._state != State.INIT) {
                return;
            }
            this._state = State.STARTED;
            this._listeners = Collections.unmodifiableSet(this._listeners);
            this._zkConnection.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        Object object = this._mutex;
        synchronized (object) {
            if (this._hasForcefullyShutdown) {
                LOG.warn("The connection has already been forcefully shutdown");
                return;
            }
            if (this._state != State.STARTED) {
                throw new IllegalStateException("Can not shutdown ZKConnection when " + (Object)((Object)this._state));
            }
            int remainingActiveUserCount = this._activeUserCount.decrementAndGet();
            int remainingRegisteredUserCount = this._registeredUserCount.decrementAndGet();
            if (remainingActiveUserCount > 0 || remainingRegisteredUserCount > 0) {
                return;
            }
            this._state = State.STOPPED;
            this._zkConnection.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceShutdown() throws InterruptedException {
        Object object = this._mutex;
        synchronized (object) {
            if (this._state != State.STARTED) {
                LOG.warn("Unnecessary to forcefully shutdown a zkPersistentConnection that is either not started or already stopped");
                return;
            }
            this._hasForcefullyShutdown = true;
            int remainingActiveUserCount = this._activeUserCount.get();
            if (remainingActiveUserCount != 0) {
                LOG.warn("Forcefully shutting down ZkPersistentConnection when there still are" + remainingActiveUserCount + " active users");
            }
            this._state = State.STOPPED;
            try {
                this._zkConnection.shutdown();
            }
            catch (IllegalStateException e) {
                LOG.warn("trying to forcefully shutdown zk connection but encountered:" + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZooKeeper getZooKeeper() {
        Object object = this._mutex;
        synchronized (object) {
            return this._zkConnection.getZooKeeper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKConnection getZKConnection() {
        Object object = this._mutex;
        synchronized (object) {
            return this._zkConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionStarted() {
        Object object = this._mutex;
        synchronized (object) {
            return this._state == State.STARTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionStopped() {
        Object object = this._mutex;
        synchronized (object) {
            return this._state == State.STOPPED;
        }
    }

    private class Listener
    implements ZKConnection.StateListener {
        private long _sessionId;

        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyStateChange(Watcher.Event.KeeperState state) {
            long sessionId = ZKPersistentConnection.this.getZooKeeper().getSessionId();
            LOG.info("Got event {} for session 0x{}", (Object)state, (Object)Long.toHexString(sessionId));
            boolean newSession = false;
            if (state == Watcher.Event.KeeperState.SyncConnected && sessionId != this._sessionId) {
                newSession = true;
                this._sessionId = sessionId;
            }
            switch (state) {
                case SyncConnected: {
                    this.deliver(newSession ? Event.SESSION_ESTABLISHED : Event.CONNECTED);
                    break;
                }
                case Disconnected: {
                    this.deliver(Event.DISCONNECTED);
                    break;
                }
                case Expired: {
                    this.deliver(Event.SESSION_EXPIRED);
                }
            }
            if (state == Watcher.Event.KeeperState.Expired) {
                try {
                    Object object = ZKPersistentConnection.this._mutex;
                    synchronized (object) {
                        if (ZKPersistentConnection.this._state == State.STARTED) {
                            ZKPersistentConnection.this._zkConnection.shutdown();
                            ZKPersistentConnection.this._zkConnection = ZKPersistentConnection.this._zkConnectionBuilder.build();
                            ZKPersistentConnection.this._zkConnection.addStateListener(new Listener());
                            ZKPersistentConnection.this._zkConnection.start();
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOG.error("Failed to shutdown ZKConnection after expiration", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("Failed to restart ZKConnection after expiration", (Throwable)e);
                }
            }
        }

        private void deliver(Event event) {
            for (EventListener listener : ZKPersistentConnection.this._listeners) {
                listener.notifyEvent(event);
            }
        }
    }

    public static class EventListenerNotifiers
    implements EventListener {
        @Override
        public void notifyEvent(Event event) {
            switch (event) {
                case SESSION_ESTABLISHED: {
                    this.sessionEstablished(event);
                    break;
                }
                case SESSION_EXPIRED: {
                    this.sessionExpired(event);
                    break;
                }
                case CONNECTED: {
                    this.connected(event);
                    break;
                }
                case DISCONNECTED: {
                    this.disconnected(event);
                }
            }
        }

        public void sessionEstablished(Event event) {
        }

        public void sessionExpired(Event event) {
        }

        public void disconnected(Event event) {
        }

        public void connected(Event event) {
        }
    }

    public static interface EventListener {
        public void notifyEvent(Event var1);
    }

    public static enum Event {
        SESSION_ESTABLISHED,
        SESSION_EXPIRED,
        DISCONNECTED,
        CONNECTED;

    }

    private static enum State {
        INIT,
        STARTED,
        STOPPED;

    }
}

