/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventBusImpl;
import com.linkedin.d2.discovery.event.PropertyEventPublisher;
import com.linkedin.d2.discovery.stores.zk.ZKPersistentConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperStore;
import com.linkedin.d2.discovery.stores.zk.builder.ZooKeeperStoreBuilder;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperConnectionAwareStore<TYPE, STORE extends ZooKeeperStore<TYPE>>
implements PropertyEventPublisher<TYPE> {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperConnectionAwareStore.class);
    private final ZKPersistentConnection _zkPersistentConnection;
    private ZooKeeperStore<TYPE> _wrappedZkStore;
    private ZooKeeperStoreBuilder<STORE> _zkStoreBuilder;
    private PropertyEventBus<TYPE> _bus;
    private boolean _pendingSetPublisher = false;
    private ConcurrentLinkedQueue<Runnable> _afterStartupCallbacks = new ConcurrentLinkedQueue();
    private volatile boolean _startupCompleted = false;

    public ZooKeeperConnectionAwareStore(ZooKeeperStoreBuilder<STORE> zooKeeperStoreBuilder, ZKPersistentConnection zkPersistentConnection) {
        this._zkPersistentConnection = zkPersistentConnection;
        this._zkPersistentConnection.addListeners(Collections.singleton(new Listener()));
        this._zkStoreBuilder = zooKeeperStoreBuilder;
    }

    public void setBusImpl(PropertyEventBusImpl<TYPE> bus) {
        this._bus = bus;
        if (this._wrappedZkStore != null) {
            bus.setPublisher(this._wrappedZkStore);
        } else {
            this._pendingSetPublisher = true;
        }
    }

    @Override
    public void setBus(PropertyEventBus<TYPE> bus) {
        if (!(bus instanceof PropertyEventBusImpl)) {
            throw new IllegalArgumentException("The bus used in LastSeenZKStore should be a PropertyEventBusImpl and not a " + bus.getClass().getName());
        }
        this.setBusImpl((PropertyEventBusImpl)bus);
    }

    @Override
    public void startPublishing(String prop) {
    }

    @Override
    public void stopPublishing(String prop) {
    }

    @Override
    public void start(Callback<None> callback) {
        this._afterStartupCallbacks.add(() -> callback.onSuccess((Object)None.none()));
        this.fireAfterStartupCallbacks();
    }

    @Override
    public void shutdown(Callback<None> callback) {
        this._afterStartupCallbacks.add(() -> this._wrappedZkStore.shutdown(callback));
        this.fireAfterStartupCallbacks();
    }

    private void fireAfterStartupCallbacks() {
        if (this._startupCompleted) {
            Runnable runnable;
            while ((runnable = this._afterStartupCallbacks.poll()) != null) {
                runnable.run();
            }
        }
    }

    private void startStore() {
        this._wrappedZkStore.start(new Callback<None>(){

            public void onError(Throwable e) {
                LOG.error("Failed to start " + ZooKeeperConnectionAwareStore.this._wrappedZkStore.getClass().getName(), e);
            }

            public void onSuccess(None result) {
                if (ZooKeeperConnectionAwareStore.this._bus != null) {
                    ZooKeeperConnectionAwareStore.this._bus.setPublisher(ZooKeeperConnectionAwareStore.this._wrappedZkStore);
                }
                ZooKeeperConnectionAwareStore.this.fireAfterStartupCallbacks();
            }
        });
    }

    private class Listener
    extends ZKPersistentConnection.EventListenerNotifiers {
        private Listener() {
        }

        @Override
        public void sessionEstablished(ZKPersistentConnection.Event event) {
            ZooKeeperConnectionAwareStore.this._zkStoreBuilder.setZkConnection(ZooKeeperConnectionAwareStore.this._zkPersistentConnection.getZKConnection());
            ZooKeeperConnectionAwareStore.this._wrappedZkStore = ZooKeeperConnectionAwareStore.this._zkStoreBuilder.build();
            if (ZooKeeperConnectionAwareStore.this._pendingSetPublisher) {
                ZooKeeperConnectionAwareStore.this._pendingSetPublisher = false;
                ZooKeeperConnectionAwareStore.this._bus.setPublisher(ZooKeeperConnectionAwareStore.this._wrappedZkStore);
            }
            ZooKeeperConnectionAwareStore.this._startupCompleted = true;
            ZooKeeperConnectionAwareStore.this.startStore();
        }

        @Override
        public void sessionExpired(ZKPersistentConnection.Event event) {
            ZooKeeperConnectionAwareStore.this._wrappedZkStore.shutdown((Callback<None>)Callbacks.empty());
        }
    }
}

