/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.CallbackAdapter;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import com.linkedin.d2.discovery.stores.file.FileStore;
import com.linkedin.d2.discovery.stores.zk.Retryable;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPropertyMerger;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperStore;
import com.linkedin.d2.discovery.stores.zk.ZookeeperChildFilter;
import com.linkedin.d2.discovery.stores.zk.ZookeeperEphemeralPrefixGenerator;
import com.linkedin.d2.discovery.util.LogUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperEphemeralStore<T>
extends ZooKeeperStore<T> {
    private static final Logger _log = LoggerFactory.getLogger(ZooKeeperEphemeralStore.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("(.*)/(.*)$");
    public static final String DEFAULT_PREFIX = "ephemoral";
    private final ZooKeeperPropertyMerger<T> _merger;
    private final ConcurrentMap<String, EphemeralStoreWatcher> _ephemeralStoreWatchers = new ConcurrentHashMap<String, EphemeralStoreWatcher>();
    private final String _ephemeralNodesFilePath;
    private final boolean _watchChildNodes;
    private final ZKStoreWatcher _zkStoreWatcher = new ZKStoreWatcher();
    private final boolean _useNewWatcher;
    private final ScheduledExecutorService _executorService;
    private final int _zookeeperReadWindowMs;
    private final ZookeeperChildFilter _zookeeperChildFilter;
    private final ZookeeperEphemeralPrefixGenerator _prefixGenerator;

    public ZooKeeperEphemeralStore(ZKConnection client, PropertySerializer<T> serializer, ZooKeeperPropertyMerger<T> merger, String path) {
        this(client, serializer, merger, path, false, false, null);
    }

    public ZooKeeperEphemeralStore(ZKConnection client, PropertySerializer<T> serializer, ZooKeeperPropertyMerger<T> merger, String path, ZookeeperChildFilter zookeeperChildFilter, ZookeeperEphemeralPrefixGenerator prefixGenerator) {
        this(client, serializer, merger, path, false, false, null, null, -1, zookeeperChildFilter, prefixGenerator);
    }

    public ZooKeeperEphemeralStore(ZKConnection client, PropertySerializer<T> serializer, ZooKeeperPropertyMerger<T> merger, String path, boolean watchChildNodes) {
        this(client, serializer, merger, path, watchChildNodes, false, null);
    }

    public ZooKeeperEphemeralStore(ZKConnection client, PropertySerializer<T> serializer, ZooKeeperPropertyMerger<T> merger, String path, boolean watchChildNodes, boolean useNewWatcher) {
        this(client, serializer, merger, path, watchChildNodes, useNewWatcher, null);
    }

    @Deprecated
    public ZooKeeperEphemeralStore(ZKConnection client, PropertySerializer<T> serializer, ZooKeeperPropertyMerger<T> merger, String path, boolean watchChildNodes, boolean useNewWatcher, String ephemeralNodesFilePath) {
        this(client, serializer, merger, path, watchChildNodes, useNewWatcher, ephemeralNodesFilePath, null, -1);
    }

    public ZooKeeperEphemeralStore(ZKConnection client, PropertySerializer<T> serializer, ZooKeeperPropertyMerger<T> merger, String path, boolean watchChildNodes, boolean useNewWatcher, String ephemeralNodesFilePath, ScheduledExecutorService executorService, int zookeeperReadWindowMs) {
        this(client, serializer, merger, path, watchChildNodes, useNewWatcher, ephemeralNodesFilePath, executorService, zookeeperReadWindowMs, null, null);
    }

    public ZooKeeperEphemeralStore(ZKConnection client, PropertySerializer<T> serializer, ZooKeeperPropertyMerger<T> merger, String path, boolean watchChildNodes, boolean useNewWatcher, String ephemeralNodesFilePath, ScheduledExecutorService executorService, int zookeeperReadWindowMs, ZookeeperChildFilter zookeeperChildFilter, ZookeeperEphemeralPrefixGenerator prefixGenerator) {
        super(client, serializer, path);
        if (watchChildNodes && useNewWatcher) {
            throw new IllegalArgumentException("watchChildNodes and useNewWatcher can not both be true.");
        }
        if (watchChildNodes && ephemeralNodesFilePath != null) {
            throw new IllegalArgumentException("watchChildNodes and ephemeralNodesFilePath, which enables a local cache for ChildNodes, can not both be enabled together.");
        }
        if (ephemeralNodesFilePath != null && !useNewWatcher) {
            _log.warn("Forcing enabling useNewWatcher with ephemeralNodesFilePath!=null");
            useNewWatcher = true;
        }
        this._zookeeperChildFilter = zookeeperChildFilter == null ? children -> children : zookeeperChildFilter;
        this._prefixGenerator = prefixGenerator == null ? () -> DEFAULT_PREFIX : prefixGenerator;
        this._merger = merger;
        this._watchChildNodes = watchChildNodes;
        this._useNewWatcher = useNewWatcher;
        this._ephemeralNodesFilePath = ephemeralNodesFilePath;
        this._executorService = executorService;
        this._zookeeperReadWindowMs = zookeeperReadWindowMs;
    }

    @Override
    public void put(String prop, final T value, final Callback<None> callback) {
        this._putStats.inc();
        LogUtil.trace(_log, "put ", prop, ": ", value);
        final String path = this.getPath(prop);
        this._zkConn.ensurePersistentNodeExists(path, new Callback<None>(){

            public void onSuccess(None none) {
                String ephemeralPrefix = ZooKeeperEphemeralStore.this._prefixGenerator.generatePrefix();
                if (StringUtils.isEmpty((CharSequence)ephemeralPrefix)) {
                    ephemeralPrefix = ZooKeeperEphemeralStore.DEFAULT_PREFIX;
                }
                String ephemeralPath = path + "/" + ephemeralPrefix + "-";
                AsyncCallback.StringCallback stringCallback = new AsyncCallback.StringCallback(){

                    public void processResult(int rc, String path, Object ctx, String name) {
                        KeeperException.Code code = KeeperException.Code.get((int)rc);
                        switch (code) {
                            case OK: {
                                callback.onSuccess((Object)None.none());
                                break;
                            }
                            default: {
                                callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                            }
                        }
                    }
                };
                if (ZooKeeperEphemeralStore.this._zk instanceof Retryable) {
                    ((Retryable)((Object)ZooKeeperEphemeralStore.this._zk)).createUniqueSequential(ephemeralPath, ZooKeeperEphemeralStore.this._serializer.toBytes(value), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, stringCallback, null);
                } else {
                    ZooKeeperEphemeralStore.this._zk.create(ephemeralPath, ZooKeeperEphemeralStore.this._serializer.toBytes(value), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, stringCallback, null);
                }
            }

            public void onError(Throwable e) {
                callback.onError(e);
            }
        });
    }

    @Override
    public void remove(String prop, Callback<None> callback) {
        this._removeStats.inc();
        LogUtil.trace(_log, "remove: ", prop);
        String path = this.getPath(prop);
        this._zkConn.removeNodeUnsafeRecursive(path, callback);
    }

    public void removePartial(String listenTo, T discoveryProperties) throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this.removePartial(listenTo, discoveryProperties, (Callback<None>)callback);
        ZooKeeperEphemeralStore.getUninterruptibly(callback);
    }

    public void removePartial(final String prop, final T value, final Callback<None> callback) {
        final String path = this.getPath(prop);
        LogUtil.trace(_log, "remove partial ", prop, ": ", value);
        final Callback childrenCallback = new Callback<Map<String, T>>(){

            public void onSuccess(Map<String, T> children) {
                String delete = ZooKeeperEphemeralStore.this._merger.unmerge(prop, value, children);
                if (delete != null) {
                    ZooKeeperEphemeralStore.this._zkConn.removeNodeUnsafe(path + "/" + delete.toString(), (Callback<None>)callback);
                } else {
                    callback.onSuccess((Object)None.none());
                }
            }

            public void onError(Throwable e) {
                callback.onError(e);
            }
        };
        this._zk.getChildren(path, false, new AsyncCallback.ChildrenCallback(){

            public void processResult(int rc, String path, Object ctx, List<String> children) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        children = ZooKeeperEphemeralStore.this._zookeeperChildFilter.filter(children);
                        if (children.size() > 0) {
                            ChildCollector collector = new ChildCollector(children.size(), childrenCallback);
                            for (String child : children) {
                                ZooKeeperEphemeralStore.this._zk.getData(path + "/" + child, false, (AsyncCallback.DataCallback)collector, null);
                            }
                            break;
                        }
                        _log.warn("Ignoring request to removePartial with no children: {}", (Object)path);
                        callback.onSuccess((Object)None.none());
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        }, null);
    }

    @Override
    public void get(String listenTo, final Callback<T> callback) {
        String path = this.getPath(listenTo);
        AsyncCallback.ChildrenCallback zkCallback = new AsyncCallback.ChildrenCallback(){

            public void processResult(int rc, String path, Object context, List<String> children) {
                KeeperException.Code result = KeeperException.Code.get((int)rc);
                switch (result) {
                    case NONODE: {
                        callback.onSuccess(null);
                        break;
                    }
                    case OK: {
                        ZooKeeperEphemeralStore.this.getMergedChildren(path, ZooKeeperEphemeralStore.this._zookeeperChildFilter.filter(children), null, callback);
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)result));
                    }
                }
            }
        };
        this._zk.getChildren(path, null, zkCallback, null);
    }

    private void getMergedChildren(String path, List<String> children, ZKStoreWatcher watcher, Callback<T> callback) {
        final String propertyName = this.getPropertyForPath(path);
        if (children.size() > 0) {
            _log.debug("getMergedChildren: collecting {}", children);
            ChildCollector collector = new ChildCollector(children.size(), (Callback)new CallbackAdapter<T, Map<String, T>>(callback){

                protected T convertResponse(Map<String, T> response) throws Exception {
                    return ZooKeeperEphemeralStore.this._merger.merge(propertyName, response.values());
                }
            });
            for (String child : children) {
                this._zk.getData(path + "/" + child, this._watchChildNodes ? watcher : null, (AsyncCallback.DataCallback)collector, null);
            }
        } else {
            _log.debug("getMergedChildren: no children");
            callback.onSuccess(this._merger.merge(propertyName, Collections.emptyList()));
        }
    }

    private void getChildrenData(String path, Collection<String> children, Callback<Map<String, T>> callback) {
        if (children.size() > 0) {
            _log.debug("getChildrenData: collecting {}", children);
            ChildCollector collector = new ChildCollector(children.size(), callback);
            children.forEach(child -> this._zk.getData(path + "/" + child, null, (AsyncCallback.DataCallback)collector, null));
        } else {
            _log.debug("getChildrenData: no children");
            callback.onSuccess(Collections.emptyMap());
        }
    }

    @Override
    public void startPublishing(String prop) {
        LogUtil.trace(_log, "register: ", prop);
        if (this._eventBus == null) {
            throw new IllegalStateException("_eventBus must not be null when publishing");
        }
        if (this._useNewWatcher) {
            EphemeralStoreWatcher watcher = this._ephemeralStoreWatchers.computeIfAbsent(prop, k -> new EphemeralStoreWatcher(prop));
            watcher.addWatch(prop);
            this._zk.getChildren(this.getPath(prop), (Watcher)watcher, (AsyncCallback.Children2Callback)watcher, (Object)true);
        } else {
            this._zkStoreWatcher.addWatch(prop);
            this._zk.getChildren(this.getPath(prop), (Watcher)this._zkStoreWatcher, (AsyncCallback.ChildrenCallback)this._zkStoreWatcher, (Object)true);
        }
    }

    @Override
    public void stopPublishing(String prop) {
        LogUtil.trace(_log, "unregister: ", prop);
        if (this._useNewWatcher) {
            EphemeralStoreWatcher watcher = (EphemeralStoreWatcher)this._ephemeralStoreWatchers.remove(prop);
            if (watcher != null) {
                watcher.cancelAllWatches();
            }
        } else {
            this._zkStoreWatcher.cancelWatch(prop);
        }
    }

    public int getListenerCount() {
        return this._useNewWatcher ? this._ephemeralStoreWatchers.size() : this._zkStoreWatcher.getWatchCount();
    }

    private class ChildCollector
    implements AsyncCallback.DataCallback {
        private int _count;
        private final Map<String, T> _properties;
        private final Callback<Map<String, T>> _callback;

        private ChildCollector(int count, Callback<Map<String, T>> callback) {
            this._count = count;
            this._properties = new HashMap(this._count);
            this._callback = callback;
        }

        public void processResult(int rc, String s, Object o, byte[] bytes, Stat stat) {
            --this._count;
            KeeperException.Code result = KeeperException.Code.get((int)rc);
            switch (result) {
                case OK: {
                    try {
                        String childPath = s.substring(s.lastIndexOf(47) + 1);
                        Object value = ZooKeeperEphemeralStore.this._serializer.fromBytes(bytes);
                        this._properties.put(childPath, value);
                        if (this._count != 0) break;
                        this._callback.onSuccess(this._properties);
                    }
                    catch (PropertySerializationException e) {
                        this._count = 0;
                        this._callback.onError((Throwable)e);
                    }
                    break;
                }
                case NONODE: {
                    if (this._count == 0) {
                        this._callback.onSuccess(this._properties);
                    }
                    _log.debug("{} doesn't exist, count={}", (Object)s, (Object)this._count);
                    break;
                }
                default: {
                    this._count = 0;
                    this._callback.onError((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                }
            }
        }
    }

    private class EphemeralStoreWatcher
    extends ZooKeeperStore.ZKStoreWatcher
    implements AsyncCallback.Children2Callback,
    AsyncCallback.StatCallback {
        private final Map<String, T> _childrenMap;
        private final String _prop;
        private long _czxid;
        private FileStore<T> _fileStore;

        EphemeralStoreWatcher(String prop) {
            super(ZooKeeperEphemeralStore.this);
            this._childrenMap = new HashMap();
            this._czxid = 0L;
            this._fileStore = null;
            this._prop = prop;
        }

        @Override
        protected void processWatch(String propertyName, WatchedEvent event) {
            if (ZooKeeperEphemeralStore.this._zookeeperReadWindowMs > 0 && ZooKeeperEphemeralStore.this._executorService != null) {
                int midPoint = ZooKeeperEphemeralStore.this._zookeeperReadWindowMs / 2;
                int delay = midPoint + ThreadLocalRandom.current().nextInt(midPoint);
                ZooKeeperEphemeralStore.this._executorService.schedule(() -> ZooKeeperEphemeralStore.this._zk.getChildren(ZooKeeperEphemeralStore.this.getPath(propertyName), (Watcher)this, (AsyncCallback.Children2Callback)this, (Object)false), (long)delay, TimeUnit.MILLISECONDS);
            } else {
                ZooKeeperEphemeralStore.this._zk.getChildren(ZooKeeperEphemeralStore.this.getPath(propertyName), (Watcher)this, (AsyncCallback.Children2Callback)this, (Object)false);
            }
        }

        public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
            KeeperException.Code code = KeeperException.Code.get((int)rc);
            _log.debug("{}: getChildren returned {}: {}", new Object[]{path, code, children});
            boolean init = (Boolean)ctx;
            String property = ZooKeeperEphemeralStore.this.getPropertyForPath(path);
            switch (code) {
                case OK: {
                    this.initCurrentNode(stat);
                    Set<String> newChildren = this.calculateChildrenDeltaAndUpdateState(children);
                    ZooKeeperEphemeralStore.this.getChildrenData(path, newChildren, this.getChildrenDataCallback(path, init, property));
                    break;
                }
                case NONODE: {
                    _log.debug("{}: node is not present, calling exists", (Object)path);
                    ZooKeeperEphemeralStore.this._zk.exists(path, this, (AsyncCallback.StatCallback)this, (Object)false);
                    if (init) {
                        ZooKeeperEphemeralStore.this._eventBus.publishInitialize(property, null);
                        _log.debug("{}: published init", (Object)path);
                    } else {
                        ZooKeeperEphemeralStore.this._eventBus.publishRemove(property);
                        _log.debug("{}: published remove", (Object)path);
                    }
                    if (this._fileStore == null) break;
                    this._fileStore.removeDirectory();
                    break;
                }
                default: {
                    _log.error("getChildren: unexpected error: {}: {}", (Object)code, (Object)path);
                }
            }
        }

        private Callback<Map<String, T>> getChildrenDataCallback(final String path, final boolean init, final String property) {
            return new Callback<Map<String, T>>(){

                public void onError(Throwable e) {
                    _log.error("Failed to merge children for path " + path, e);
                    if (init) {
                        ZooKeeperEphemeralStore.this._eventBus.publishInitialize(property, null);
                    }
                    _log.debug("{}: published init", (Object)path);
                }

                public void onSuccess(Map<String, T> result) {
                    EphemeralStoreWatcher.this._childrenMap.putAll(result);
                    if (EphemeralStoreWatcher.this._fileStore != null) {
                        result.forEach(EphemeralStoreWatcher.this._fileStore::put);
                    }
                    if (init) {
                        ZooKeeperEphemeralStore.this._eventBus.publishInitialize(property, ZooKeeperEphemeralStore.this._merger.merge(property, EphemeralStoreWatcher.this._childrenMap.values()));
                        _log.debug("{}: published init", (Object)path);
                    } else {
                        ZooKeeperEphemeralStore.this._eventBus.publishAdd(property, ZooKeeperEphemeralStore.this._merger.merge(property, EphemeralStoreWatcher.this._childrenMap.values()));
                        _log.debug("{}: published add", (Object)path);
                    }
                }
            };
        }

        private void initCurrentNode(Stat stat) {
            if (this._czxid != stat.getCzxid()) {
                if (this._czxid != 0L) {
                    this._childrenMap.clear();
                    if (ZooKeeperEphemeralStore.this._ephemeralNodesFilePath != null) {
                        FileStore.removeDirectory(ZooKeeperEphemeralStore.this._ephemeralNodesFilePath + File.separator + this._prop);
                    }
                }
                this._czxid = stat.getCzxid();
                if (ZooKeeperEphemeralStore.this._ephemeralNodesFilePath != null) {
                    this._fileStore = new FileStore(ZooKeeperEphemeralStore.this._ephemeralNodesFilePath + File.separator + this._prop + File.separator + this._czxid, ".ini", ZooKeeperEphemeralStore.this._serializer);
                    this._fileStore.start();
                    this._childrenMap.putAll(this._fileStore.getAll());
                }
            }
        }

        private Set<String> calculateChildrenDeltaAndUpdateState(List<String> children) {
            HashSet<String> oldChildren = new HashSet<String>(this._childrenMap.keySet());
            oldChildren.removeAll(children);
            oldChildren.forEach(this._childrenMap::remove);
            if (this._fileStore != null) {
                oldChildren.forEach(this._fileStore::remove);
            }
            HashSet<String> newChildren = new HashSet<String>(children);
            newChildren.removeAll(this._childrenMap.keySet());
            return newChildren;
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            KeeperException.Code code = KeeperException.Code.get((int)rc);
            _log.debug("{}: exists returned {}", (Object)path, (Object)code);
            switch (code) {
                case OK: {
                    _log.debug("{}: calling getChildren", (Object)path);
                    ZooKeeperEphemeralStore.this._zk.getChildren(path, (Watcher)this, (AsyncCallback.Children2Callback)this, (Object)false);
                    break;
                }
                case NONODE: {
                    _log.debug("{}: set exists watch", (Object)path);
                    break;
                }
                default: {
                    _log.error("exists: unexpected error: {}: {}", (Object)code, (Object)path);
                }
            }
        }
    }

    private class ZKStoreWatcher
    extends ZooKeeperStore.ZKStoreWatcher
    implements AsyncCallback.ChildrenCallback,
    AsyncCallback.StatCallback {
        private ZKStoreWatcher() {
            super(ZooKeeperEphemeralStore.this);
        }

        private String getParentPath(String inputPath) {
            Matcher m = PATH_PATTERN.matcher(inputPath);
            if (m.matches()) {
                String parent = m.group(1);
                String child = m.group(2);
                if (parent != null && !parent.isEmpty() && child != null && !child.isEmpty()) {
                    return parent;
                }
                if (parent != null && parent.isEmpty() && child != null && !child.isEmpty()) {
                    return "/";
                }
            }
            return null;
        }

        @Override
        protected String watchedPropertyPath(String inputPath) {
            if (this.containsWatch(ZooKeeperEphemeralStore.this.getPropertyForPath(inputPath))) {
                return inputPath;
            }
            String parentPath = this.getParentPath(inputPath);
            if (ZooKeeperEphemeralStore.this._path.equals(parentPath)) {
                return null;
            }
            if (parentPath != null && this.containsWatch(ZooKeeperEphemeralStore.this.getPropertyForPath(parentPath))) {
                return parentPath;
            }
            return null;
        }

        @Override
        public void processWatch(String propertyName, WatchedEvent watchedEvent) {
            ZooKeeperEphemeralStore.this._zk.getChildren(ZooKeeperEphemeralStore.this.getPath(propertyName), (Watcher)this, (AsyncCallback.ChildrenCallback)this, (Object)false);
        }

        public void processResult(int rc, final String path, Object ctx, List<String> children) {
            KeeperException.Code code = KeeperException.Code.get((int)rc);
            _log.debug("{}: getChildren returned {}: {}", new Object[]{path, code, children});
            final boolean init = (Boolean)ctx;
            final String property = ZooKeeperEphemeralStore.this.getPropertyForPath(path);
            switch (code) {
                case OK: {
                    ZooKeeperEphemeralStore.this.getMergedChildren(path, children, this, new Callback<T>(){

                        public void onSuccess(T value) {
                            if (init) {
                                ZooKeeperEphemeralStore.this._eventBus.publishInitialize(property, value);
                                _log.debug("{}: published init", (Object)path);
                            } else {
                                ZooKeeperEphemeralStore.this._eventBus.publishAdd(property, value);
                                _log.debug("{}: published add", (Object)path);
                            }
                        }

                        public void onError(Throwable e) {
                            _log.error("Failed to merge children for path " + path, e);
                            if (init) {
                                ZooKeeperEphemeralStore.this._eventBus.publishInitialize(property, null);
                                _log.debug("{}: published init", (Object)path);
                            }
                        }
                    });
                    break;
                }
                case NONODE: {
                    _log.debug("{}: node is not present, calling exists", (Object)path);
                    ZooKeeperEphemeralStore.this._zk.exists(path, this, (AsyncCallback.StatCallback)this, (Object)false);
                    if (init) {
                        ZooKeeperEphemeralStore.this._eventBus.publishInitialize(property, null);
                        _log.debug("{}: published init", (Object)path);
                        break;
                    }
                    ZooKeeperEphemeralStore.this._eventBus.publishRemove(property);
                    _log.debug("{}: published remove", (Object)path);
                    break;
                }
                default: {
                    _log.error("getChildren: unexpected error: {}: {}", (Object)code, (Object)path);
                }
            }
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            KeeperException.Code code = KeeperException.Code.get((int)rc);
            _log.debug("{}: exists returned {}", (Object)path, (Object)code);
            switch (code) {
                case OK: {
                    _log.debug("{}: calling getChildren", (Object)path);
                    ZooKeeperEphemeralStore.this._zk.getChildren(path, (Watcher)this, (AsyncCallback.ChildrenCallback)this, (Object)false);
                    break;
                }
                case NONODE: {
                    _log.debug("{}: set exists watch", (Object)path);
                    break;
                }
                default: {
                    _log.error("exists: unexpected error: {}: {}", (Object)code, (Object)path);
                }
            }
        }
    }
}

