/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk.acl;

import com.linkedin.d2.discovery.stores.zk.AbstractZooKeeper;
import com.linkedin.d2.discovery.stores.zk.ZKPersistentConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import com.linkedin.d2.discovery.stores.zk.acl.ZKAclProvider;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclAwareZookeeper
extends AbstractZooKeeper {
    private static final Logger LOG = LoggerFactory.getLogger(ZKPersistentConnection.class);
    private static final String DIGEST_AUTH_SCHEME = "digest";
    private final ZKAclProvider _aclProvider;

    public AclAwareZookeeper(@Nonnull ZooKeeper zooKeeper, @Nonnull ZKAclProvider aclProvider) {
        super(zooKeeper);
        this._aclProvider = aclProvider;
        String authScheme = this._aclProvider.getAuthScheme();
        byte[] authInfo = this._aclProvider.getAuthInfo();
        if (authScheme != null && authScheme.equals(DIGEST_AUTH_SCHEME) && authInfo != null) {
            LOG.info("Adding authentication info when initiate connection to zookeeper");
            super.addAuthInfo(authScheme, authInfo);
        }
    }

    @Override
    public void addAuthInfo(String scheme, byte[] auth) {
        throw new UnsupportedOperationException("This zookeeper client is managed by ZkAclProvider. Authentication Info to Zookeeper should be applied through ZKAclProvider");
    }

    @Override
    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        if (createMode == CreateMode.EPHEMERAL_SEQUENTIAL || createMode == CreateMode.EPHEMERAL) {
            return super.create(path, data, this._aclProvider.getACL(), createMode);
        }
        return super.create(path, data, acl, createMode);
    }

    @Override
    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        if (createMode == CreateMode.EPHEMERAL_SEQUENTIAL || createMode == CreateMode.EPHEMERAL) {
            super.create(path, data, this._aclProvider.getACL(), createMode, cb, ctx);
        } else {
            super.create(path, data, acl, createMode, cb, ctx);
        }
    }

    @Override
    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        throw new UnsupportedOperationException("This zookeeper client is managed by ZkAclProvider, all acls need to be set through the provider");
    }

    @Override
    public void setACL(String path, List<ACL> acl, int version, AsyncCallback.StatCallback cb, Object ctx) {
        throw new UnsupportedOperationException("This zookeeper client is managed by ZkAclProvider, all acls need to be set through the provider");
    }
}

