/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk.builder;

import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPropertyMerger;
import com.linkedin.d2.discovery.stores.zk.ZookeeperChildFilter;
import com.linkedin.d2.discovery.stores.zk.ZookeeperEphemeralPrefixGenerator;
import com.linkedin.d2.discovery.stores.zk.builder.ZooKeeperStoreBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ZooKeeperEphemeralStoreBuilder<T>
implements ZooKeeperStoreBuilder<ZooKeeperEphemeralStore<T>> {
    private static final String URIS_VALUES_DIRECTORY = "urisValues";
    private ZKConnection _client;
    private PropertySerializer<T> _serializer;
    private ZooKeeperPropertyMerger<T> _merger;
    private String _path;
    private boolean _watchChildNodes = false;
    private boolean _useNewWatcher = false;
    private String _fsD2DirPathForBackup = null;
    private ScheduledExecutorService _executorService;
    private int _zookeeperReadWindowMs = -1;
    private ZookeeperChildFilter _zookeeperChildFilter = null;
    private ZookeeperEphemeralPrefixGenerator _zookeeperEphemeralPrefixGenerator = null;
    private List<Consumer<ZooKeeperEphemeralStore<T>>> _onBuildListeners = new ArrayList<Consumer<ZooKeeperEphemeralStore<T>>>();

    @Override
    public void setZkConnection(ZKConnection client) {
        this._client = client;
    }

    public ZooKeeperEphemeralStoreBuilder<T> setSerializer(PropertySerializer<T> serializer) {
        this._serializer = serializer;
        return this;
    }

    public ZooKeeperEphemeralStoreBuilder<T> setMerger(ZooKeeperPropertyMerger<T> merger) {
        this._merger = merger;
        return this;
    }

    public ZooKeeperEphemeralStoreBuilder<T> setPath(String path) {
        this._path = path;
        return this;
    }

    public ZooKeeperEphemeralStoreBuilder<T> setWatchChildNodes(boolean watchChildNodes) {
        this._watchChildNodes = watchChildNodes;
        return this;
    }

    public ZooKeeperEphemeralStoreBuilder<T> setUseNewWatcher(boolean useNewWatcher) {
        this._useNewWatcher = useNewWatcher;
        return this;
    }

    public ZooKeeperEphemeralStoreBuilder<T> setBackupStoreFilePath(@Nullable String fsd2DirPathForBackup) {
        this._fsD2DirPathForBackup = fsd2DirPathForBackup;
        return this;
    }

    public ZooKeeperEphemeralStoreBuilder<T> setExecutorService(ScheduledExecutorService executorService) {
        this._executorService = executorService;
        return this;
    }

    public ZooKeeperEphemeralStoreBuilder<T> setZookeeperReadWindowMs(int zookeeperReadWindowMs) {
        this._zookeeperReadWindowMs = zookeeperReadWindowMs;
        return this;
    }

    public ZooKeeperEphemeralStoreBuilder<T> setZookeeperChildFilter(ZookeeperChildFilter zookeeperChildFilter) {
        this._zookeeperChildFilter = zookeeperChildFilter;
        return this;
    }

    public ZooKeeperEphemeralStoreBuilder<T> setZookeeperEphemeralPrefixGenerator(ZookeeperEphemeralPrefixGenerator zookeeperEphemeralPrefixGenerator) {
        this._zookeeperEphemeralPrefixGenerator = zookeeperEphemeralPrefixGenerator;
        return this;
    }

    @Override
    public ZooKeeperEphemeralStoreBuilder<T> addOnBuildListener(Consumer<ZooKeeperEphemeralStore<T>> onBuildListener) {
        this._onBuildListeners.add(onBuildListener);
        return this;
    }

    @Override
    public ZooKeeperEphemeralStore<T> build() {
        String backupStoreFilePath = null;
        if (this._fsD2DirPathForBackup != null) {
            backupStoreFilePath = this._fsD2DirPathForBackup + File.separator + URIS_VALUES_DIRECTORY;
        }
        ZooKeeperEphemeralStore<T> zooKeeperEphemeralStore = new ZooKeeperEphemeralStore<T>(this._client, this._serializer, this._merger, this._path, this._watchChildNodes, this._useNewWatcher, backupStoreFilePath, this._executorService, this._zookeeperReadWindowMs, this._zookeeperChildFilter, this._zookeeperEphemeralPrefixGenerator);
        for (Consumer<ZooKeeperEphemeralStore<ZooKeeperEphemeralStore<T>>> consumer : this._onBuildListeners) {
            consumer.accept(zooKeeperEphemeralStore);
        }
        return zooKeeperEphemeralStore;
    }
}

