/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk.builder;

import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPermanentStore;
import com.linkedin.d2.discovery.stores.zk.builder.ZooKeeperStoreBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;

public class ZooKeeperPermanentStoreBuilder<T>
implements ZooKeeperStoreBuilder<ZooKeeperPermanentStore<T>> {
    private ZKConnection client;
    private PropertySerializer<T> serializer;
    private String path;
    private ScheduledExecutorService executorService;
    private int zookeeperReadWindowMs = -1;
    private List<Consumer<ZooKeeperPermanentStore<T>>> _onBuildListeners = new ArrayList<Consumer<ZooKeeperPermanentStore<T>>>();

    @Override
    public void setZkConnection(ZKConnection client) {
        this.client = client;
    }

    public ZooKeeperPermanentStoreBuilder<T> setSerializer(PropertySerializer<T> serializer) {
        this.serializer = serializer;
        return this;
    }

    public ZooKeeperPermanentStoreBuilder<T> setPath(String path) {
        this.path = path;
        return this;
    }

    public ZooKeeperPermanentStoreBuilder<T> setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ZooKeeperPermanentStoreBuilder<T> setZookeeperReadWindowMs(int zookeeperReadWindowMs) {
        this.zookeeperReadWindowMs = zookeeperReadWindowMs;
        return this;
    }

    @Override
    public ZooKeeperPermanentStoreBuilder<T> addOnBuildListener(Consumer<ZooKeeperPermanentStore<T>> onBuildListener) {
        this._onBuildListeners.add(onBuildListener);
        return this;
    }

    @Override
    public ZooKeeperPermanentStore<T> build() {
        ZooKeeperPermanentStore<T> zooKeeperPermanentStore = new ZooKeeperPermanentStore<T>(this.client, this.serializer, this.path, this.executorService, this.zookeeperReadWindowMs);
        for (Consumer<ZooKeeperPermanentStore<ZooKeeperPermanentStore<T>>> consumer : this._onBuildListeners) {
            consumer.accept(zooKeeperPermanentStore);
        }
        return zooKeeperPermanentStore;
    }
}

