/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.d2.balancer.LoadBalancerStateItem;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.simple.ClusterInfoItem;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancer;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancerState;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.discovery.stores.file.FileStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPermanentStore;
import com.linkedin.d2.jmx.JmxManager;
import com.linkedin.util.ArgumentUtil;
import javax.annotation.Nonnull;

public class D2ClientJmxManager {
    private final String _prefix;
    private final JmxManager _jmxManager;

    public D2ClientJmxManager(String prefix, @Nonnull JmxManager jmxManager) {
        ArgumentUtil.ensureNotNull((Object)jmxManager, (String)"jmxManager");
        this._prefix = prefix;
        this._jmxManager = jmxManager;
    }

    public void setSimpleLoadBalancer(SimpleLoadBalancer balancer) {
        String jmxName = this._prefix + "-LoadBalancer";
        this._jmxManager.registerLoadBalancer(jmxName, balancer);
    }

    public void setSimpleLoadBalancerState(SimpleLoadBalancerState state) {
        this._jmxManager.registerLoadBalancerState(this._prefix + "-LoadBalancerState", state);
        state.register(new SimpleLoadBalancerState.SimpleLoadBalancerStateListener(){

            @Override
            public void onStrategyAdded(String serviceName, String scheme, LoadBalancerStrategy strategy) {
                D2ClientJmxManager.this._jmxManager.registerLoadBalancerStrategy(this.getLoadBalancerStrategyJmxName(serviceName, scheme), strategy);
            }

            @Override
            public void onStrategyRemoved(String serviceName, String scheme, LoadBalancerStrategy strategy) {
                D2ClientJmxManager.this._jmxManager.unregister(this.getLoadBalancerStrategyJmxName(serviceName, scheme));
            }

            @Override
            public void onClientAdded(String clusterName, TrackerClient client) {
            }

            @Override
            public void onClientRemoved(String clusterName, TrackerClient client) {
            }

            @Override
            public void onClusterInfoUpdate(ClusterInfoItem clusterInfoItem) {
                D2ClientJmxManager.this._jmxManager.registerClusterInfo(this.getClusterInfoJmxName(clusterInfoItem.getClusterPropertiesItem().getProperty().getClusterName()), clusterInfoItem);
            }

            @Override
            public void onClusterInfoRemoval(ClusterInfoItem clusterInfoItem) {
                D2ClientJmxManager.this._jmxManager.unregister(this.getClusterInfoJmxName(clusterInfoItem.getClusterPropertiesItem().getProperty().getClusterName()));
            }

            @Override
            public void onServicePropertiesUpdate(LoadBalancerStateItem<ServiceProperties> serviceProperties) {
                D2ClientJmxManager.this._jmxManager.registerServiceProperties(this.getServicePropertiesJmxName(serviceProperties.getProperty().getServiceName()), serviceProperties);
            }

            @Override
            public void onServicePropertiesRemoval(LoadBalancerStateItem<ServiceProperties> serviceProperties) {
                D2ClientJmxManager.this._jmxManager.unregister(this.getServicePropertiesJmxName(serviceProperties.getProperty().getServiceName()));
            }

            private String getClusterInfoJmxName(String clusterName) {
                return String.format("%s-ClusterInfo", clusterName);
            }

            private String getServicePropertiesJmxName(String serviceName) {
                return String.format("%s-ServiceProperties", serviceName);
            }

            private String getLoadBalancerStrategyJmxName(String serviceName, String scheme) {
                return serviceName + "-" + scheme + "-LoadBalancerStrategy";
            }
        });
    }

    public <T> void setZkUriRegistry(ZooKeeperEphemeralStore<T> uriRegistry) {
        this._jmxManager.registerZooKeeperEphemeralStore(this._prefix + "-ZooKeeperUriRegistry", uriRegistry);
    }

    public <T> void setZkClusterRegistry(ZooKeeperPermanentStore<T> clusterRegistry) {
        this._jmxManager.registerZooKeeperPermanentStore(this._prefix + "-ZooKeeperClusterRegistry", clusterRegistry);
    }

    public <T> void setZkServiceRegistry(ZooKeeperPermanentStore<T> serviceRegistry) {
        this._jmxManager.registerZooKeeperPermanentStore(this._prefix + "-ZooKeeperServiceRegistry", serviceRegistry);
    }

    public <T> void setFsUriStore(FileStore<T> uriStore) {
        this._jmxManager.registerFileStore(this._prefix + "-FileStoreUriStore", uriStore);
    }

    public <T> void setFsClusterStore(FileStore<T> clusterStore) {
        this._jmxManager.registerFileStore(this._prefix + "-FileStoreClusterStore", clusterStore);
    }

    public <T> void setFsServiceStore(FileStore<T> serviceStore) {
        this._jmxManager.registerFileStore(this._prefix + "-FileStoreServiceStore", serviceStore);
    }
}

