/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.d2.balancer.clients.DegraderTrackerClient;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyV3;
import com.linkedin.d2.balancer.strategies.relative.StateUpdater;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.jmx.DegraderLoadBalancerStrategyV3JmxMBean;
import com.linkedin.d2.jmx.RelativeLoadBalancerStrategyJmx;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DegraderLoadBalancerStrategyV3Jmx
implements DegraderLoadBalancerStrategyV3JmxMBean {
    private final DegraderLoadBalancerStrategyV3 _strategy;

    public DegraderLoadBalancerStrategyV3Jmx(DegraderLoadBalancerStrategyV3 strategy) {
        this._strategy = strategy;
    }

    @Override
    public double getOverrideClusterDropRate() {
        double rate = this._strategy.getState().getPartitionState(0).getCurrentOverrideDropRate();
        return rate;
    }

    @Override
    public String toString() {
        return "DegraderLoadBalancerStrategyV3Jmx [_strategy=" + this._strategy + "]";
    }

    @Override
    public int getTotalPointsInHashRing() {
        Map<URI, Integer> uris = this._strategy.getState().getPartitionState(0).getPointsMap();
        int total = 0;
        for (Map.Entry<URI, Integer> entry : uris.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    @Override
    public String getPointsMap(int partitionId) {
        return this._strategy.getState().getPartitionState(partitionId).getPointsMap().toString();
    }

    @Override
    public String getUnhealthyClientsPoints(int partitionId) {
        int pointsPerWeight = this._strategy.getConfig().getPointsPerWeight();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<URI, Integer> entry : this._strategy.getState().getPartitionState(partitionId).getPointsMap().entrySet()) {
            if (entry.getValue() >= pointsPerWeight) continue;
            result.add(entry.getKey().toString() + ":" + entry.getValue() + "/" + pointsPerWeight);
        }
        return ((Object)result).toString();
    }

    @Override
    public String getRingInformation(int partitionId) {
        Ring<URI> ring = this._strategy.getRing(partitionId);
        if (ring == null) {
            return "Ring for that partition is null";
        }
        return ring.toString();
    }

    @Override
    public long getCurrentClusterCallCount(int partitionId) {
        long currentClusterCallCount = this._strategy.getState().getPartitionState(partitionId).getCurrentClusterCallCount();
        return currentClusterCallCount;
    }

    @Override
    public double getCurrentAvgClusterLatency(int partitionId) {
        double currentAvgClusterLatency = this._strategy.getState().getPartitionState(partitionId).getCurrentAvgClusterLatency();
        return currentAvgClusterLatency;
    }

    @Override
    public double getLatencyStandardDeviation() {
        Set<DegraderTrackerClient> trackerClients = this._strategy.getState().getPartitionState(0).getTrackerClients();
        return RelativeLoadBalancerStrategyJmx.calculateStandardDeviation(trackerClients);
    }

    @Override
    public double getMaxLatencyRelativeFactor() {
        Set<DegraderTrackerClient> trackerClients = this._strategy.getState().getPartitionState(0).getTrackerClients();
        double avgLatency = RelativeLoadBalancerStrategyJmx.getAvgClusterLatency(trackerClients);
        long maxLatency = trackerClients.stream().map(trackerClient -> StateUpdater.getAvgHostLatency(trackerClient.getCallTracker().getCallStats())).mapToLong(Long::longValue).max().orElse(0L);
        return avgLatency == 0.0 ? 0.0 : (double)maxLatency / avgLatency;
    }

    @Override
    public double getNthPercentileLatencyRelativeFactor(double pct) {
        Set<DegraderTrackerClient> trackerClients = this._strategy.getState().getPartitionState(0).getTrackerClients();
        if (trackerClients.size() == 0) {
            return 0.0;
        }
        double avgLatency = RelativeLoadBalancerStrategyJmx.getAvgClusterLatency(trackerClients);
        List weightedLatencies = trackerClients.stream().map(trackerClient -> StateUpdater.getAvgHostLatency(trackerClient.getCallTracker().getCallStats())).sorted().collect(Collectors.toList());
        int nth = Math.max((int)(pct * (double)weightedLatencies.size()) - 1, 0);
        long nthLatency = (Long)weightedLatencies.get(nth);
        return avgLatency == 0.0 ? 0.0 : (double)nthLatency / avgLatency;
    }
}

