/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.LoadBalancerQuarantine;
import com.linkedin.d2.balancer.strategies.relative.RelativeLoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.relative.StateUpdater;
import com.linkedin.d2.balancer.strategies.relative.TrackerClientState;
import com.linkedin.d2.jmx.RelativeLoadBalancerStrategyJmxMBean;
import com.linkedin.util.degrader.CallTracker;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RelativeLoadBalancerStrategyJmx
implements RelativeLoadBalancerStrategyJmxMBean {
    private static final double DEFAULT_DOUBLE_METRICS = 0.0;
    private static final int DEFAULT_INT_METRICS = 0;
    private final RelativeLoadBalancerStrategy _strategy;

    public RelativeLoadBalancerStrategyJmx(RelativeLoadBalancerStrategy strategy) {
        this._strategy = strategy;
    }

    @Override
    public double getLatencyStandardDeviation() {
        if (this.isPartitionDataUnavailable()) {
            return 0.0;
        }
        Map<TrackerClient, TrackerClientState> stateMap = this._strategy.getPartitionState(this._strategy.getFirstValidPartitionId()).getTrackerClientStateMap();
        return RelativeLoadBalancerStrategyJmx.calculateStandardDeviation(stateMap.keySet());
    }

    @Override
    public double getLatencyMeanAbsoluteDeviation() {
        if (this.isPartitionDataUnavailable()) {
            return 0.0;
        }
        Map<TrackerClient, TrackerClientState> stateMap = this._strategy.getPartitionState(this._strategy.getFirstValidPartitionId()).getTrackerClientStateMap();
        double avgLatency = RelativeLoadBalancerStrategyJmx.getAvgClusterLatency(stateMap.keySet());
        return stateMap.keySet().stream().filter(RelativeLoadBalancerStrategyJmx::hasTraffic).map(trackerClient -> Math.abs((double)StateUpdater.getAvgHostLatency(trackerClient.getCallTracker().getCallStats()) - avgLatency)).mapToDouble(Double::doubleValue).average().orElse(0.0);
    }

    @Override
    public double getAboveAverageLatencyStandardDeviation() {
        if (this.isPartitionDataUnavailable()) {
            return 0.0;
        }
        Map<TrackerClient, TrackerClientState> stateMap = this._strategy.getPartitionState(this._strategy.getFirstValidPartitionId()).getTrackerClientStateMap();
        double avgLatency = RelativeLoadBalancerStrategyJmx.getAvgClusterLatency(stateMap.keySet());
        Set aboveAvgClients = stateMap.keySet().stream().filter(trackerClient -> (double)StateUpdater.getAvgHostLatency(trackerClient.getCallTracker().getCallStats()) > avgLatency).collect(Collectors.toSet());
        return RelativeLoadBalancerStrategyJmx.calculateStandardDeviation(aboveAvgClients);
    }

    @Override
    public double getMaxLatencyRelativeFactor() {
        if (this.isPartitionDataUnavailable()) {
            return 0.0;
        }
        Map<TrackerClient, TrackerClientState> stateMap = this._strategy.getPartitionState(this._strategy.getFirstValidPartitionId()).getTrackerClientStateMap();
        double avgLatency = RelativeLoadBalancerStrategyJmx.getAvgClusterLatency(stateMap.keySet());
        long maxLatency = stateMap.keySet().stream().map(trackerClient -> StateUpdater.getAvgHostLatency(trackerClient.getCallTracker().getCallStats())).mapToLong(Long::longValue).max().orElse(0L);
        return avgLatency == 0.0 ? 0.0 : (double)maxLatency / avgLatency;
    }

    @Override
    public double getNthPercentileLatencyRelativeFactor(double pct) {
        if (this.isPartitionDataUnavailable()) {
            return 0.0;
        }
        Map<TrackerClient, TrackerClientState> stateMap = this._strategy.getPartitionState(this._strategy.getFirstValidPartitionId()).getTrackerClientStateMap();
        if (stateMap.size() == 0) {
            return 0.0;
        }
        double avgLatency = RelativeLoadBalancerStrategyJmx.getAvgClusterLatency(stateMap.keySet());
        List weightedLatencies = stateMap.keySet().stream().map(trackerClient -> StateUpdater.getAvgHostLatency(trackerClient.getCallTracker().getCallStats())).sorted().collect(Collectors.toList());
        int nth = Math.max((int)(pct * (double)weightedLatencies.size()) - 1, 0);
        long nthLatency = (Long)weightedLatencies.get(nth);
        return avgLatency == 0.0 ? 0.0 : (double)nthLatency / avgLatency;
    }

    @Override
    public int getUnhealthyHostsCount() {
        if (this.isPartitionDataUnavailable()) {
            return 0;
        }
        Map<TrackerClient, TrackerClientState> stateMap = this._strategy.getPartitionState(this._strategy.getFirstValidPartitionId()).getTrackerClientStateMap();
        return (int)stateMap.values().stream().filter(TrackerClientState::isUnhealthy).count();
    }

    @Override
    public int getQuarantineHostsCount() {
        if (this.isPartitionDataUnavailable()) {
            return 0;
        }
        Map<TrackerClient, LoadBalancerQuarantine> quarantineMap = this._strategy.getPartitionState(this._strategy.getFirstValidPartitionId()).getQuarantineMap();
        return (int)quarantineMap.values().stream().filter(LoadBalancerQuarantine::isInQuarantine).count();
    }

    @Override
    public int getTotalPointsInHashRing() {
        if (this.isPartitionDataUnavailable()) {
            return 0;
        }
        Map<URI, Integer> uris = this._strategy.getPartitionState(this._strategy.getFirstValidPartitionId()).getPointsMap();
        return uris.values().stream().mapToInt(Integer::intValue).sum();
    }

    static boolean hasTraffic(TrackerClient trackerClient) {
        CallTracker.CallStats stats = trackerClient.getCallTracker().getCallStats();
        return stats.getOutstandingCount() + stats.getCallCount() > 0;
    }

    static double calculateStandardDeviation(Set<? extends TrackerClient> trackerClients) {
        double avgLatency = RelativeLoadBalancerStrategyJmx.getAvgClusterLatency(trackerClients);
        double variance = trackerClients.stream().filter(RelativeLoadBalancerStrategyJmx::hasTraffic).map(trackerClient -> Math.pow((double)StateUpdater.getAvgHostLatency(trackerClient.getCallTracker().getCallStats()) - avgLatency, 2.0)).mapToDouble(Double::doubleValue).average().orElse(0.0);
        return Math.sqrt(variance);
    }

    static long getAvgClusterLatency(Set<? extends TrackerClient> trackerClients) {
        long latencySum = 0L;
        long outstandingLatencySum = 0L;
        int callCountSum = 0;
        int outstandingCallCountSum = 0;
        for (TrackerClient trackerClient : trackerClients) {
            CallTracker.CallStats latestCallStats = trackerClient.getCallTracker().getCallStats();
            int callCount = latestCallStats.getCallCount();
            int outstandingCallCount = latestCallStats.getOutstandingCount();
            latencySum = (long)((double)latencySum + latestCallStats.getCallTimeStats().getAverage() * (double)callCount);
            outstandingLatencySum += latestCallStats.getOutstandingStartTimeAvg() * (long)outstandingCallCount;
            callCountSum += callCount;
            outstandingCallCountSum += outstandingCallCount;
        }
        return callCountSum + outstandingCallCountSum == 0 ? 0L : Math.round((double)(latencySum + outstandingLatencySum) / (double)(callCountSum + outstandingCallCountSum));
    }

    private boolean isPartitionDataUnavailable() {
        return this._strategy.getPartitionState(this._strategy.getFirstValidPartitionId()) == null;
    }
}

