/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.servers.ZooKeeperServer;
import com.linkedin.d2.discovery.stores.PropertyStoreException;
import com.linkedin.d2.jmx.ZooKeeperServerJmxMXBean;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ZooKeeperServerJmx
implements ZooKeeperServerJmxMXBean {
    private final ZooKeeperServer _server;

    public ZooKeeperServerJmx(ZooKeeperServer server) {
        this._server = server;
    }

    @Override
    public void setMarkDown(String clusterName, String uri) throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this._server.markDown(clusterName, URI.create(uri), (Callback<None>)callback);
        try {
            callback.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new PropertyStoreException(e);
        }
    }

    @Override
    public void setMarkUp(String clusterName, String uri, double weight) throws PropertyStoreException {
        HashMap<Integer, PartitionData> partitionDataMap = new HashMap<Integer, PartitionData>(1);
        partitionDataMap.put(0, new PartitionData(weight));
        this.setMarkup(clusterName, uri, partitionDataMap, Collections.emptyMap());
    }

    @Override
    public void setMarkup(String clusterName, String uri, Map<Integer, PartitionData> partitionDataMap) throws PropertyStoreException {
        this.setMarkup(clusterName, uri, partitionDataMap, Collections.emptyMap());
    }

    @Override
    public void setMarkup(String clusterName, String uri, Map<Integer, PartitionData> partitionDataMap, Map<String, Object> uriSpecificProperties) throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this._server.markUp(clusterName, URI.create(uri), partitionDataMap, uriSpecificProperties, (Callback<None>)callback);
        try {
            callback.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new PropertyStoreException(e);
        }
    }

    @Override
    public void setChangeWeight(String clusterName, String uri, Map<Integer, PartitionData> partitionDataMap, boolean doNotSlowStart) throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this._server.changeWeight(clusterName, URI.create(uri), partitionDataMap, doNotSlowStart, (Callback<None>)callback);
        try {
            callback.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new PropertyStoreException(e);
        }
    }

    @Override
    public void setDoNotLoadBalance(String clusterName, String uri, Map<Integer, PartitionData> partitionDataMap, boolean doNotLoadBalance) throws PropertyStoreException {
        FutureCallback callback = new FutureCallback();
        this._server.addUriSpecificProperty(clusterName, "doNotLoadBalance", URI.create(uri), partitionDataMap, "doNotLoadBalance", doNotLoadBalance, (Callback<None>)callback);
        try {
            callback.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new PropertyStoreException(e);
        }
    }
}

