/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.callback;

import com.linkedin.common.callback.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CallbackAdapter<OLD, NEW>
implements Callback<NEW> {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackAdapter.class);
    private final Callback<OLD> _callback;

    protected CallbackAdapter(Callback<OLD> callback) {
        this._callback = callback;
    }

    protected abstract OLD convertResponse(NEW var1) throws Exception;

    protected Throwable convertError(Throwable error) {
        return error;
    }

    @Override
    public void onSuccess(NEW response) {
        OLD newResponse;
        try {
            newResponse = this.convertResponse(response);
        }
        catch (Throwable e) {
            this._callback.onError(e);
            return;
        }
        this._callback.onSuccess(newResponse);
    }

    @Override
    public void onError(Throwable e) {
        Throwable newThrowable;
        try {
            newThrowable = this.convertError(e);
        }
        catch (Throwable ex) {
            LOG.error("Failed to convert callback error, original exception follows:", e);
            newThrowable = ex;
        }
        this._callback.onError(newThrowable);
    }
}

