/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util;

import com.linkedin.util.clock.Clock;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class RateLimitedLogger
implements Logger {
    private static final long INIT_TIME = -1L;
    private final Logger _loggerImpl;
    private final long _logRate;
    private final Clock _clock;
    private final AtomicLong _lastLog = new AtomicLong(-1L);

    public RateLimitedLogger(Logger loggerImpl, long logRate, Clock clock) {
        this._loggerImpl = loggerImpl;
        this._logRate = logRate;
        this._clock = clock;
    }

    public String getName() {
        return this._loggerImpl.getName();
    }

    public boolean isTraceEnabled() {
        return this._loggerImpl.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(msg);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(msg, t);
        }
    }

    public void trace(String format, Object obj) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(format, obj);
        }
    }

    public void trace(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(format, obj1, obj2);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this._loggerImpl.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(marker, msg);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(marker, format, arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(marker, format, arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(marker, format, arguments);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.logAllowed()) {
            this._loggerImpl.trace(marker, msg, t);
        }
    }

    public boolean isDebugEnabled() {
        return this._loggerImpl.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(msg);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(msg, t);
        }
    }

    public void debug(String format, Object obj) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(format, obj);
        }
    }

    public void debug(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(format, obj1, obj2);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this._loggerImpl.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(marker, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(marker, format, arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.logAllowed()) {
            this._loggerImpl.debug(marker, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this._loggerImpl.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.info(msg);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.info(format, arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.logAllowed()) {
            this._loggerImpl.info(msg, t);
        }
    }

    public void info(String format, Object obj) {
        if (this.logAllowed()) {
            this._loggerImpl.info(format, obj);
        }
    }

    public void info(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._loggerImpl.info(format, obj1, obj2);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this._loggerImpl.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.info(marker, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.logAllowed()) {
            this._loggerImpl.info(marker, format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logAllowed()) {
            this._loggerImpl.info(marker, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.info(marker, format, arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.logAllowed()) {
            this._loggerImpl.info(marker, msg, t);
        }
    }

    public boolean isWarnEnabled() {
        return this._loggerImpl.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(msg);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(format, arguments);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(msg, t);
        }
    }

    public void warn(String format, Object obj) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(format, obj);
        }
    }

    public void warn(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(format, obj1, obj2);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this._loggerImpl.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(marker, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(marker, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(marker, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(marker, format, arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.logAllowed()) {
            this._loggerImpl.warn(marker, msg, t);
        }
    }

    public boolean isErrorEnabled() {
        return this._loggerImpl.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.error(msg);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.error(format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.logAllowed()) {
            this._loggerImpl.error(msg, t);
        }
    }

    public void error(String format, Object obj) {
        if (this.logAllowed()) {
            this._loggerImpl.error(format, obj);
        }
    }

    public void error(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._loggerImpl.error(format, obj1, obj2);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this._loggerImpl.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        if (this.logAllowed()) {
            this._loggerImpl.error(marker, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.logAllowed()) {
            this._loggerImpl.error(marker, format, arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logAllowed()) {
            this._loggerImpl.error(marker, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.logAllowed()) {
            this._loggerImpl.error(marker, format, arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.logAllowed()) {
            this._loggerImpl.error(marker, msg, t);
        }
    }

    private boolean logAllowed() {
        long now = this._clock.currentTimeMillis();
        long lastLog = this._lastLog.get();
        return (lastLog == -1L || now - lastLog >= this._logRate) && this._lastLog.compareAndSet(lastLog, now);
    }
}

