/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation;

import io.activej.aggregation.AggregationPredicate;
import io.activej.aggregation.AggregationPredicates;
import io.activej.aggregation.PrimaryKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AggregationChunk {
    private final Object chunkId;
    private final List<String> measures;
    private final PrimaryKey minPrimaryKey;
    private final PrimaryKey maxPrimaryKey;
    private final int count;

    public static AggregationChunk create(Object chunkId, List<String> fields, PrimaryKey minPrimaryKey, PrimaryKey maxPrimaryKey, int count) {
        return new AggregationChunk(chunkId, fields, minPrimaryKey, maxPrimaryKey, count);
    }

    private AggregationChunk(Object chunkId, List<String> measures, PrimaryKey minPrimaryKey, PrimaryKey maxPrimaryKey, int count) {
        this.chunkId = chunkId;
        this.measures = measures;
        this.minPrimaryKey = minPrimaryKey;
        this.maxPrimaryKey = maxPrimaryKey;
        this.count = count;
    }

    public Object getChunkId() {
        return this.chunkId;
    }

    public List<String> getMeasures() {
        return Collections.unmodifiableList(this.measures);
    }

    public PrimaryKey getMinPrimaryKey() {
        return this.minPrimaryKey;
    }

    public PrimaryKey getMaxPrimaryKey() {
        return this.maxPrimaryKey;
    }

    public int getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationChunk chunk = (AggregationChunk)o;
        return Objects.equals(this.chunkId, chunk.chunkId);
    }

    public int hashCode() {
        return Objects.hash(this.chunkId, this.measures, this.minPrimaryKey, this.maxPrimaryKey, this.count);
    }

    public AggregationPredicate toPredicate(List<String> primaryKey) {
        ArrayList<AggregationPredicate> predicates = new ArrayList<AggregationPredicate>();
        for (int i = 0; i < primaryKey.size(); ++i) {
            Object to;
            String key = primaryKey.get(i);
            Object from = this.minPrimaryKey.get(i);
            if (from.equals(to = this.maxPrimaryKey.get(i))) {
                predicates.add(AggregationPredicates.eq(key, from));
                continue;
            }
            predicates.add(AggregationPredicates.between(key, (Comparable)from, (Comparable)to));
        }
        return AggregationPredicates.and(predicates);
    }

    public String toString() {
        return "{id=" + this.chunkId + ", measures=" + this.measures + ", minKey=" + this.minPrimaryKey + ", maxKey=" + this.maxPrimaryKey + ", count=" + this.count + '}';
    }
}

