/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation;

import io.activej.aggregation.AggregationPredicate;
import io.activej.aggregation.PrimaryKey;
import io.activej.aggregation.fieldtype.FieldType;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.common.Checks;
import io.activej.common.collection.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class AggregationPredicates {
    private static final Map<PredicateSimplifierKey<?, ?>, PredicateSimplifier<?, ?>> simplifiers = new HashMap();

    public static <L extends AggregationPredicate, R extends AggregationPredicate> void register(Class<L> leftType, Class<R> rightType, PredicateSimplifier<L, R> operation) {
        PredicateSimplifierKey keyLeftRight = new PredicateSimplifierKey(leftType, rightType);
        Checks.checkState((!simplifiers.containsKey(keyLeftRight) ? 1 : 0) != 0, (String)"Key '%s has already been registered", (Object[])new Object[]{keyLeftRight});
        simplifiers.put(keyLeftRight, operation);
        if (!rightType.equals(leftType)) {
            PredicateSimplifierKey keyRightLeft = new PredicateSimplifierKey(rightType, leftType);
            Checks.checkState((!simplifiers.containsKey(keyRightLeft) ? 1 : 0) != 0, (String)"Key '%s has already been registered", (Object[])new Object[]{keyRightLeft});
            simplifiers.put(keyRightLeft, (right, left) -> operation.simplifyAnd(left, right));
        }
    }

    public static AggregationPredicate alwaysTrue() {
        return PredicateAlwaysTrue.instance;
    }

    public static AggregationPredicate alwaysFalse() {
        return PredicateAlwaysFalse.instance;
    }

    public static AggregationPredicate not(AggregationPredicate predicate) {
        return new PredicateNot(predicate);
    }

    public static AggregationPredicate and(List<AggregationPredicate> predicates) {
        return new PredicateAnd(predicates);
    }

    public static AggregationPredicate and(AggregationPredicate ... predicates) {
        return AggregationPredicates.and(Arrays.asList(predicates));
    }

    public static AggregationPredicate or(List<AggregationPredicate> predicates) {
        return new PredicateOr(predicates);
    }

    public static AggregationPredicate or(AggregationPredicate ... predicates) {
        return AggregationPredicates.or(Arrays.asList(predicates));
    }

    public static AggregationPredicate eq(String key, @Nullable Object value) {
        return new PredicateEq(key, value);
    }

    public static AggregationPredicate notEq(String key, Object value) {
        return new PredicateNotEq(key, value);
    }

    public static AggregationPredicate ge(String key, Comparable value) {
        return new PredicateGe(key, value);
    }

    public static AggregationPredicate le(String key, Comparable value) {
        return new PredicateLe(key, value);
    }

    public static AggregationPredicate gt(String key, Comparable value) {
        return new PredicateGt(key, value);
    }

    public static AggregationPredicate lt(String key, Comparable value) {
        return new PredicateLt(key, value);
    }

    public static AggregationPredicate has(String key) {
        return new PredicateHas(key);
    }

    public static AggregationPredicate in(String key, Collection values) {
        return values.size() == 1 ? new PredicateEq(key, values.toArray()[0]) : new PredicateIn(key, new TreeSet(values));
    }

    public static AggregationPredicate in(String key, Comparable ... values) {
        return values.length == 1 ? new PredicateEq(key, values[0]) : new PredicateIn(key, new TreeSet<Comparable>(Arrays.asList(values)));
    }

    public static AggregationPredicate regexp(String key, String pattern) {
        return new PredicateRegexp(key, Pattern.compile(pattern));
    }

    public static AggregationPredicate regexp(String key, Pattern pattern) {
        return new PredicateRegexp(key, pattern);
    }

    public static AggregationPredicate between(String key, Comparable from, Comparable to) {
        return new PredicateBetween(key, from, to);
    }

    private static Expression isNotNull(Expression field, FieldType fieldType) {
        return fieldType != null && fieldType.getInternalDataType().isPrimitive() ? E.alwaysTrue() : E.isNotNull((Expression)field);
    }

    private static Expression isNull(Expression field, FieldType fieldType) {
        return fieldType != null && fieldType.getInternalDataType().isPrimitive() ? E.alwaysFalse() : E.isNull((Expression)field);
    }

    private static Object toInternalValue(Map<String, FieldType> fields, String key, Object value) {
        return fields.containsKey(key) ? fields.get(key).toInternalValue(value) : value;
    }

    private static Expression toStringValue(Map<String, FieldType> fields, String key, Expression value) {
        return fields.containsKey(key) ? fields.get(key).toStringValue(value) : value;
    }

    public static RangeScan toRangeScan(AggregationPredicate predicate, List<String> primaryKey, Map<String, FieldType> fields) {
        if ((predicate = predicate.simplify()) == AggregationPredicates.alwaysFalse()) {
            return RangeScan.noScan();
        }
        ArrayList<AggregationPredicate> conjunctions = new ArrayList<AggregationPredicate>();
        if (predicate instanceof PredicateAnd) {
            conjunctions.addAll(((PredicateAnd)predicate).predicates);
        } else {
            conjunctions.add(predicate);
        }
        ArrayList<Object> from = new ArrayList<Object>();
        ArrayList<Object> to = new ArrayList<Object>();
        block0: for (String key : primaryKey) {
            for (int j = 0; j < conjunctions.size(); ++j) {
                AggregationPredicate conjunction = (AggregationPredicate)conjunctions.get(j);
                if (conjunction instanceof PredicateEq && ((PredicateEq)conjunction).key.equals(key)) {
                    conjunctions.remove(j);
                    PredicateEq eq = (PredicateEq)conjunction;
                    from.add(AggregationPredicates.toInternalValue(fields, eq.key, eq.value));
                    to.add(AggregationPredicates.toInternalValue(fields, eq.key, eq.value));
                    continue block0;
                }
                if (!(conjunction instanceof PredicateBetween) || !((PredicateBetween)conjunction).key.equals(key)) continue;
                conjunctions.remove(j);
                PredicateBetween between = (PredicateBetween)conjunction;
                from.add(AggregationPredicates.toInternalValue(fields, between.key, between.from));
                to.add(AggregationPredicates.toInternalValue(fields, between.key, between.to));
                break block0;
            }
        }
        return RangeScan.rangeScan(PrimaryKey.ofList(from), PrimaryKey.ofList(to));
    }

    static {
        PredicateSimplifier<PredicateAlwaysFalse, AggregationPredicate> simplifierAlwaysFalse = (left, right) -> left;
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateAlwaysFalse.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateAlwaysTrue.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateNot.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateEq.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateNotEq.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateLe.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateGe.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateLt.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateGt.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateHas.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateBetween.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateRegexp.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateAnd.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateOr.class, simplifierAlwaysFalse);
        AggregationPredicates.register(PredicateAlwaysFalse.class, PredicateIn.class, simplifierAlwaysFalse);
        PredicateSimplifier<PredicateAlwaysTrue, AggregationPredicate> simplifierAlwaysTrue = (left, right) -> right;
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateAlwaysTrue.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateNot.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateEq.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateNotEq.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateLe.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateGe.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateLt.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateGt.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateHas.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateBetween.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateRegexp.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateAnd.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateOr.class, simplifierAlwaysTrue);
        AggregationPredicates.register(PredicateAlwaysTrue.class, PredicateIn.class, simplifierAlwaysTrue);
        PredicateSimplifier<PredicateNot, AggregationPredicate> simplifierNot = (left, right) -> {
            if (((PredicateNot)left).predicate.equals(right)) {
                return AggregationPredicates.alwaysFalse();
            }
            return null;
        };
        AggregationPredicates.register(PredicateNot.class, PredicateNot.class, simplifierNot);
        AggregationPredicates.register(PredicateNot.class, PredicateHas.class, simplifierNot);
        AggregationPredicates.register(PredicateNot.class, PredicateBetween.class, simplifierNot);
        AggregationPredicates.register(PredicateNot.class, PredicateRegexp.class, simplifierNot);
        AggregationPredicates.register(PredicateNot.class, PredicateAnd.class, simplifierNot);
        AggregationPredicates.register(PredicateNot.class, PredicateOr.class, simplifierNot);
        AggregationPredicates.register(PredicateNot.class, PredicateGe.class, simplifierNot);
        AggregationPredicates.register(PredicateNot.class, PredicateLe.class, simplifierNot);
        AggregationPredicates.register(PredicateNot.class, PredicateGt.class, simplifierNot);
        AggregationPredicates.register(PredicateNot.class, PredicateLt.class, simplifierNot);
        AggregationPredicates.register(PredicateNot.class, PredicateIn.class, simplifierNot);
        AggregationPredicates.register(PredicateHas.class, PredicateHas.class, (left, right) -> left.key.equals(right.key) ? left : null);
        PredicateSimplifier<PredicateHas, AggregationPredicate> simplifierHas = (left, right) -> right.getDimensions().contains(left.getKey()) ? right : null;
        AggregationPredicates.register(PredicateHas.class, PredicateEq.class, simplifierHas);
        AggregationPredicates.register(PredicateHas.class, PredicateNotEq.class, (left, right) -> left.key.equals(right.key) ? left : null);
        AggregationPredicates.register(PredicateHas.class, PredicateLe.class, simplifierHas);
        AggregationPredicates.register(PredicateHas.class, PredicateGe.class, simplifierHas);
        AggregationPredicates.register(PredicateHas.class, PredicateLt.class, simplifierHas);
        AggregationPredicates.register(PredicateHas.class, PredicateGt.class, simplifierHas);
        AggregationPredicates.register(PredicateHas.class, PredicateBetween.class, simplifierHas);
        AggregationPredicates.register(PredicateHas.class, PredicateAnd.class, simplifierHas);
        AggregationPredicates.register(PredicateHas.class, PredicateOr.class, simplifierHas);
        AggregationPredicates.register(PredicateHas.class, PredicateIn.class, simplifierHas);
        AggregationPredicates.register(PredicateEq.class, PredicateEq.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            return AggregationPredicates.alwaysFalse();
        });
        AggregationPredicates.register(PredicateEq.class, PredicateNotEq.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (!left.value.equals(right.value)) {
                return left;
            }
            return AggregationPredicates.alwaysFalse();
        });
        AggregationPredicates.register(PredicateEq.class, PredicateLe.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) >= 0) {
                return left;
            }
            return AggregationPredicates.alwaysFalse();
        });
        AggregationPredicates.register(PredicateEq.class, PredicateGe.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) <= 0) {
                return left;
            }
            return AggregationPredicates.alwaysFalse();
        });
        AggregationPredicates.register(PredicateEq.class, PredicateLt.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) > 0) {
                return left;
            }
            return AggregationPredicates.alwaysFalse();
        });
        AggregationPredicates.register(PredicateEq.class, PredicateGt.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) < 0) {
                return left;
            }
            return AggregationPredicates.alwaysFalse();
        });
        AggregationPredicates.register(PredicateEq.class, PredicateBetween.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.from.compareTo(left.value) <= 0 && right.to.compareTo(left.value) >= 0) {
                return left;
            }
            return AggregationPredicates.alwaysFalse();
        });
        AggregationPredicates.register(PredicateEq.class, PredicateRegexp.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.regexp.matcher(left.key).matches()) {
                return left;
            }
            return AggregationPredicates.alwaysFalse();
        });
        AggregationPredicates.register(PredicateEq.class, PredicateIn.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.values.contains(left.value)) {
                return left;
            }
            return AggregationPredicates.alwaysFalse();
        });
        AggregationPredicates.register(PredicateNotEq.class, PredicateNotEq.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (left.value.equals(right.value)) {
                return left;
            }
            return null;
        });
        AggregationPredicates.register(PredicateNotEq.class, PredicateLe.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) < 0) {
                return right;
            }
            if (right.value.compareTo(left.value) == 0) {
                return AggregationPredicates.lt(left.key, right.value);
            }
            return null;
        });
        AggregationPredicates.register(PredicateNotEq.class, PredicateGe.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) > 0) {
                return right;
            }
            if (right.value.compareTo(left.value) == 0) {
                return AggregationPredicates.gt(left.key, right.value);
            }
            return null;
        });
        AggregationPredicates.register(PredicateNotEq.class, PredicateLt.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) <= 0) {
                return right;
            }
            return null;
        });
        AggregationPredicates.register(PredicateNotEq.class, PredicateGt.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) >= 0) {
                return right;
            }
            return null;
        });
        AggregationPredicates.register(PredicateNotEq.class, PredicateBetween.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.from.compareTo(left.value) > 0 && right.to.compareTo(left.value) > 0) {
                return right;
            }
            if (right.from.compareTo(left.value) < 0 && right.to.compareTo(left.value) < 0) {
                return right;
            }
            return null;
        });
        AggregationPredicates.register(PredicateLe.class, PredicateLe.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) <= 0) {
                return right;
            }
            return left;
        });
        AggregationPredicates.register(PredicateLe.class, PredicateGe.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (left.value.compareTo(right.value) < 0) {
                return AggregationPredicates.alwaysFalse();
            }
            if (left.value.compareTo(right.value) > 0) {
                return AggregationPredicates.between(right.key, right.value, left.value);
            }
            if (left.value.compareTo(right.value) == 0) {
                return AggregationPredicates.eq(left.key, left.value);
            }
            return null;
        });
        AggregationPredicates.register(PredicateLe.class, PredicateLt.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) <= 0) {
                return right;
            }
            return left;
        });
        AggregationPredicates.register(PredicateLe.class, PredicateGt.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (left.value.compareTo(right.value) <= 0) {
                return AggregationPredicates.alwaysFalse();
            }
            return null;
        });
        AggregationPredicates.register(PredicateLe.class, PredicateBetween.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.from.compareTo(left.value) > 0) {
                return AggregationPredicates.alwaysFalse();
            }
            if (right.from.compareTo(left.value) == 0) {
                return AggregationPredicates.eq(left.key, right.from);
            }
            if (right.to.compareTo(left.value) <= 0) {
                return right;
            }
            return AggregationPredicates.between(right.key, right.from, left.value).simplify();
        });
        AggregationPredicates.register(PredicateLe.class, PredicateIn.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (left.value.compareTo(right.values.last()) >= 0) {
                return right;
            }
            if (left.value.compareTo(right.values.first()) < 0) {
                return AggregationPredicates.alwaysFalse();
            }
            TreeSet<Comparable> subset = new TreeSet<Comparable>(right.values.headSet(left.value));
            if (right.values.contains(left.value)) {
                subset.add(left.value);
            }
            return AggregationPredicates.in(left.key, subset);
        });
        AggregationPredicates.register(PredicateGe.class, PredicateGe.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) >= 0) {
                return right;
            }
            return left;
        });
        AggregationPredicates.register(PredicateGe.class, PredicateLt.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) <= 0) {
                return AggregationPredicates.alwaysFalse();
            }
            return null;
        });
        AggregationPredicates.register(PredicateGe.class, PredicateGt.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) >= 0) {
                return AggregationPredicates.gt(right.key, right.value);
            }
            return left;
        });
        AggregationPredicates.register(PredicateGe.class, PredicateBetween.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.to.compareTo(left.value) < 0) {
                return AggregationPredicates.alwaysFalse();
            }
            if (right.to.compareTo(left.value) == 0) {
                return AggregationPredicates.eq(right.key, right.to);
            }
            if (right.from.compareTo(left.value) >= 0) {
                return right;
            }
            return AggregationPredicates.between(right.key, left.value, right.to).simplify();
        });
        AggregationPredicates.register(PredicateGe.class, PredicateIn.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (left.value.compareTo(right.values.first()) <= 0) {
                return right;
            }
            if (left.value.compareTo(right.values.last()) > 0) {
                return AggregationPredicates.alwaysFalse();
            }
            return AggregationPredicates.in(left.key, new TreeSet<Comparable>(right.values.tailSet(left.value)));
        });
        AggregationPredicates.register(PredicateLt.class, PredicateLt.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) >= 0) {
                return left;
            }
            return right;
        });
        AggregationPredicates.register(PredicateLt.class, PredicateGt.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (left.value.compareTo(right.value) <= 0) {
                return AggregationPredicates.alwaysFalse();
            }
            return null;
        });
        AggregationPredicates.register(PredicateLt.class, PredicateBetween.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.from.compareTo(left.value) >= 0) {
                return AggregationPredicates.alwaysFalse();
            }
            if (right.to.compareTo(left.value) < 0) {
                return right;
            }
            return null;
        });
        AggregationPredicates.register(PredicateLt.class, PredicateIn.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (left.value.compareTo(right.values.last()) > 0) {
                return right;
            }
            if (left.value.compareTo(right.values.first()) < 0) {
                return AggregationPredicates.alwaysFalse();
            }
            return AggregationPredicates.in(left.key, new TreeSet<Comparable>(right.values.subSet(right.values.first(), left.value)));
        });
        AggregationPredicates.register(PredicateGt.class, PredicateGt.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.value.compareTo(left.value) >= 0) {
                return right;
            }
            return left;
        });
        AggregationPredicates.register(PredicateGt.class, PredicateBetween.class, (left, right) -> {
            if (!right.key.equals(left.key)) {
                return null;
            }
            if (right.to.compareTo(left.value) <= 0) {
                return AggregationPredicates.alwaysFalse();
            }
            if (right.from.compareTo(left.value) > 0) {
                return right;
            }
            return null;
        });
        AggregationPredicates.register(PredicateGt.class, PredicateIn.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (left.value.compareTo(right.values.first()) < 0) {
                return right;
            }
            if (left.value.compareTo(right.values.last()) >= 0) {
                return AggregationPredicates.alwaysFalse();
            }
            SortedSet<Comparable> subset = right.values.tailSet(left.value);
            subset.remove(left.value);
            return AggregationPredicates.in(right.key, subset);
        });
        AggregationPredicates.register(PredicateBetween.class, PredicateBetween.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            Comparable from = left.from.compareTo(right.from) >= 0 ? left.from : right.from;
            Comparable to = left.to.compareTo(right.to) <= 0 ? left.to : right.to;
            return AggregationPredicates.between(left.key, from, to).simplify();
        });
        AggregationPredicates.register(PredicateBetween.class, PredicateIn.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (left.from.compareTo(right.values.first()) > 0 && left.to.compareTo(right.values.last()) > 0) {
                return left;
            }
            return null;
        });
        AggregationPredicates.register(PredicateIn.class, PredicateIn.class, (left, right) -> {
            if (!left.key.equals(right.key)) {
                return null;
            }
            if (left.values.equals(right.values)) {
                return left.values.size() == 1 ? AggregationPredicates.eq(left.getKey(), left.values.first()) : left;
            }
            SortedSet values = left.values;
            values.retainAll(right.values);
            if (values.size() == 1) {
                return AggregationPredicates.eq(left.key, left.values.first());
            }
            if (!left.values.isEmpty()) {
                return AggregationPredicates.in(left.key, left.values);
            }
            return AggregationPredicates.alwaysFalse();
        });
    }

    public static final class RangeScan {
        private final PrimaryKey from;
        private final PrimaryKey to;

        private RangeScan(PrimaryKey from, PrimaryKey to) {
            this.from = from;
            this.to = to;
        }

        public static RangeScan noScan() {
            return new RangeScan(null, null);
        }

        public static RangeScan fullScan() {
            return new RangeScan(PrimaryKey.ofArray(new Object[0]), PrimaryKey.ofArray(new Object[0]));
        }

        public static RangeScan rangeScan(PrimaryKey from, PrimaryKey to) {
            return new RangeScan(from, to);
        }

        public boolean isNoScan() {
            return this.from == null;
        }

        public boolean isFullScan() {
            return this.from.size() == 0;
        }

        public boolean isRangeScan() {
            return !this.isNoScan() && !this.isFullScan();
        }

        public PrimaryKey getFrom() {
            Checks.checkState((!this.isNoScan() ? 1 : 0) != 0, (Object)"Cannot return 'from' in 'No Scan' mode");
            return this.from;
        }

        public PrimaryKey getTo() {
            Checks.checkState((!this.isNoScan() ? 1 : 0) != 0, (Object)"Cannot return 'to' in 'No Scan' mode");
            return this.to;
        }
    }

    public static final class PredicateOr
    implements AggregationPredicate {
        final List<AggregationPredicate> predicates;

        PredicateOr(List<AggregationPredicate> predicates) {
            this.predicates = predicates;
        }

        public List<AggregationPredicate> getPredicates() {
            return this.predicates;
        }

        @Override
        public AggregationPredicate simplify() {
            LinkedHashSet<AggregationPredicate> simplifiedPredicates = new LinkedHashSet<AggregationPredicate>();
            for (AggregationPredicate predicate : this.predicates) {
                AggregationPredicate simplified = predicate.simplify();
                if (simplified instanceof PredicateOr) {
                    simplifiedPredicates.addAll(((PredicateOr)simplified).predicates);
                    continue;
                }
                simplifiedPredicates.add(simplified);
            }
            return simplifiedPredicates.isEmpty() ? AggregationPredicates.alwaysTrue() : (simplifiedPredicates.size() == 1 ? (AggregationPredicate)CollectionUtils.first(simplifiedPredicates) : AggregationPredicates.or(new ArrayList<AggregationPredicate>(simplifiedPredicates)));
        }

        @Override
        public Set<String> getDimensions() {
            HashSet<String> result = new HashSet<String>();
            for (AggregationPredicate predicate : this.predicates) {
                result.addAll(predicate.getDimensions());
            }
            return result;
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            ArrayList<Expression> predicateDefs = new ArrayList<Expression>();
            for (AggregationPredicate predicate : this.predicates) {
                predicateDefs.add(predicate.createPredicate(record, fields));
            }
            return E.or(predicateDefs);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateOr that = (PredicateOr)o;
            return new HashSet<AggregationPredicate>(this.predicates).equals(new HashSet<AggregationPredicate>(that.predicates));
        }

        @Override
        public int hashCode() {
            return new HashSet<AggregationPredicate>(this.predicates).hashCode();
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(" OR ");
            for (AggregationPredicate predicate : this.predicates) {
                joiner.add(predicate != null ? predicate.toString() : null);
            }
            return "(" + joiner.toString() + ")";
        }
    }

    public static final class PredicateAnd
    implements AggregationPredicate {
        final List<AggregationPredicate> predicates;

        private PredicateAnd(List<AggregationPredicate> predicates) {
            this.predicates = predicates;
        }

        public List<AggregationPredicate> getPredicates() {
            return this.predicates;
        }

        @Override
        public AggregationPredicate simplify() {
            boolean simplified;
            HashSet simplifiedPredicates = new LinkedHashSet<AggregationPredicate>();
            for (AggregationPredicate predicate : this.predicates) {
                AggregationPredicate simplified2 = predicate.simplify();
                if (simplified2 instanceof PredicateAnd) {
                    simplifiedPredicates.addAll(((PredicateAnd)simplified2).predicates);
                    continue;
                }
                simplifiedPredicates.add(simplified2);
            }
            do {
                simplified = false;
                HashSet<AggregationPredicate> newPredicates = new HashSet<AggregationPredicate>();
                block2: for (AggregationPredicate newPredicate : simplifiedPredicates) {
                    for (AggregationPredicate simplifiedPredicate : newPredicates) {
                        AggregationPredicate maybeSimplified = PredicateAnd.simplifyAnd(newPredicate, simplifiedPredicate);
                        if (maybeSimplified == null) continue;
                        newPredicates.remove(simplifiedPredicate);
                        newPredicates.add(maybeSimplified);
                        simplified = true;
                        continue block2;
                    }
                    newPredicates.add(newPredicate);
                }
                simplifiedPredicates = newPredicates;
            } while (simplified);
            return simplifiedPredicates.isEmpty() ? AggregationPredicates.alwaysTrue() : (simplifiedPredicates.size() == 1 ? (AggregationPredicate)CollectionUtils.first((Iterable)simplifiedPredicates) : AggregationPredicates.and(new ArrayList<AggregationPredicate>(simplifiedPredicates)));
        }

        @Nullable
        private static AggregationPredicate simplifyAnd(AggregationPredicate left, AggregationPredicate right) {
            if (left.equals(right)) {
                return left;
            }
            PredicateSimplifierKey key = new PredicateSimplifierKey(left.getClass(), right.getClass());
            PredicateSimplifier simplifier = (PredicateSimplifier)simplifiers.get(key);
            if (simplifier == null) {
                return null;
            }
            return simplifier.simplifyAnd(left, right);
        }

        @Override
        public Set<String> getDimensions() {
            HashSet<String> result = new HashSet<String>();
            for (AggregationPredicate predicate : this.predicates) {
                result.addAll(predicate.getDimensions());
            }
            return result;
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (AggregationPredicate predicate : this.predicates) {
                result.putAll(predicate.getFullySpecifiedDimensions());
            }
            return result;
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            ArrayList<Expression> predicateDefs = new ArrayList<Expression>();
            for (AggregationPredicate predicate : this.predicates) {
                predicateDefs.add(predicate.createPredicate(record, fields));
            }
            return E.and(predicateDefs);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateAnd that = (PredicateAnd)o;
            return new HashSet<AggregationPredicate>(this.predicates).equals(new HashSet<AggregationPredicate>(that.predicates));
        }

        @Override
        public int hashCode() {
            return new HashSet<AggregationPredicate>(this.predicates).hashCode();
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(" AND ");
            for (AggregationPredicate predicate : this.predicates) {
                joiner.add(predicate != null ? predicate.toString() : null);
            }
            return "(" + joiner.toString() + ")";
        }
    }

    public static final class PredicateBetween
    implements AggregationPredicate {
        final String key;
        final Comparable from;
        final Comparable to;

        PredicateBetween(String key, Comparable from, Comparable to) {
            this.key = key;
            this.from = from;
            this.to = to;
        }

        public String getKey() {
            return this.key;
        }

        public Comparable getFrom() {
            return this.from;
        }

        public Comparable getTo() {
            return this.to;
        }

        @Override
        public AggregationPredicate simplify() {
            return this.from.compareTo(this.to) > 0 ? AggregationPredicates.alwaysFalse() : (this.from.equals(this.to) ? AggregationPredicates.eq(this.key, this.from) : this);
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.singleton(this.key);
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            Variable property = E.property((Expression)record, (String)this.key.replace('.', '$'));
            return E.and((Expression[])new Expression[]{AggregationPredicates.isNotNull((Expression)property, fields.get(this.key)), E.cmpGe((Expression)property, (Expression)E.value((Object)AggregationPredicates.toInternalValue(fields, this.key, this.from))), E.cmpLe((Expression)property, (Expression)E.value((Object)AggregationPredicates.toInternalValue(fields, this.key, this.to)))});
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateBetween that = (PredicateBetween)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            if (!this.from.equals(that.from)) {
                return false;
            }
            return this.to.equals(that.to);
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.from.hashCode();
            result = 31 * result + this.to.hashCode();
            return result;
        }

        public String toString() {
            return "" + this.key + " BETWEEN " + this.from + " AND " + this.to;
        }
    }

    public static final class PredicateIn
    implements AggregationPredicate {
        final String key;
        final SortedSet values;

        PredicateIn(String key, SortedSet values) {
            this.key = key;
            this.values = values;
        }

        public String getKey() {
            return this.key;
        }

        public Set getValues() {
            return this.values;
        }

        @Override
        public AggregationPredicate simplify() {
            return this.values.iterator().hasNext() ? this : AggregationPredicates.alwaysFalse();
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.singleton(this.key);
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            return E.cmpNe((Expression)E.value((Object)false), (Expression)E.call((Expression)E.value((Object)this.values), (String)"contains", (Expression[])new Expression[]{E.cast((Expression)E.property((Expression)record, (String)this.key.replace('.', '$')), Object.class)}));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateIn that = (PredicateIn)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Objects.equals(this.values, that.values);
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ");
            for (Object value : this.values) {
                joiner.add(value != null ? value.toString() : null);
            }
            return "" + this.key + " IN " + joiner.toString();
        }
    }

    public static final class PredicateRegexp
    implements AggregationPredicate {
        final String key;
        final Pattern regexp;

        private PredicateRegexp(String key, Pattern regexp) {
            this.key = key;
            this.regexp = regexp;
        }

        public String getKey() {
            return this.key;
        }

        public String getRegexp() {
            return this.regexp.pattern();
        }

        public Pattern getRegexpPattern() {
            return this.regexp;
        }

        @Override
        public AggregationPredicate simplify() {
            return this;
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.singleton(this.key);
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            Variable value = E.property((Expression)record, (String)this.key.replace('.', '$'));
            return E.and((Expression)AggregationPredicates.isNotNull((Expression)value, fields.get(this.key)), (Expression)E.cmpNe((Expression)E.value((Object)false), (Expression)E.call((Expression)E.call((Expression)E.value((Object)this.regexp), (String)"matcher", (Expression[])new Expression[]{AggregationPredicates.toStringValue(fields, this.key, (Expression)value)}), (String)"matches", (Expression[])new Expression[0])));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateRegexp that = (PredicateRegexp)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return this.regexp.pattern().equals(that.regexp.pattern());
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.regexp.pattern().hashCode();
            return result;
        }

        public String toString() {
            return this.key + " " + this.regexp.pattern();
        }
    }

    public static final class PredicateHas
    implements AggregationPredicate {
        final String key;

        private PredicateHas(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public AggregationPredicate simplify() {
            return this;
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.emptySet();
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            return fields.containsKey(this.key) ? E.alwaysTrue() : E.alwaysFalse();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateHas that = (PredicateHas)o;
            return this.key.equals(that.key);
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result;
            return result;
        }

        public String toString() {
            return "HAS " + this.key;
        }
    }

    public static final class PredicateGt
    implements AggregationPredicate {
        final String key;
        final Comparable value;

        private PredicateGt(String key, Comparable value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Comparable getValue() {
            return this.value;
        }

        @Override
        public AggregationPredicate simplify() {
            return this;
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.singleton(this.key);
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            Variable property = E.property((Expression)record, (String)this.key.replace('.', '$'));
            return E.and((Expression)AggregationPredicates.isNotNull((Expression)property, fields.get(this.key)), (Expression)E.cmpGt((Expression)property, (Expression)E.value((Object)AggregationPredicates.toInternalValue(fields, this.key, this.value))));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateGt that = (PredicateGt)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.key + ">" + this.value;
        }
    }

    public static final class PredicateGe
    implements AggregationPredicate {
        final String key;
        final Comparable value;

        private PredicateGe(String key, Comparable value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Comparable getValue() {
            return this.value;
        }

        @Override
        public AggregationPredicate simplify() {
            return this;
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.singleton(this.key);
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            Variable property = E.property((Expression)record, (String)this.key.replace('.', '$'));
            return E.and((Expression)AggregationPredicates.isNotNull((Expression)property, fields.get(this.key)), (Expression)E.cmpGe((Expression)property, (Expression)E.value((Object)AggregationPredicates.toInternalValue(fields, this.key, this.value))));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateGe that = (PredicateGe)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.key + ">=" + this.value;
        }
    }

    public static final class PredicateLt
    implements AggregationPredicate {
        final String key;
        final Comparable value;

        private PredicateLt(String key, Comparable value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public AggregationPredicate simplify() {
            return this;
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.singleton(this.key);
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            Variable property = E.property((Expression)record, (String)this.key.replace('.', '$'));
            return E.and((Expression)AggregationPredicates.isNotNull((Expression)property, fields.get(this.key)), (Expression)E.cmpLt((Expression)property, (Expression)E.value((Object)AggregationPredicates.toInternalValue(fields, this.key, this.value))));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateLt that = (PredicateLt)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.key + "<" + this.value;
        }
    }

    public static final class PredicateLe
    implements AggregationPredicate {
        final String key;
        final Comparable value;

        private PredicateLe(String key, Comparable value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public AggregationPredicate simplify() {
            return this;
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.singleton(this.key);
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            Variable property = E.property((Expression)record, (String)this.key.replace('.', '$'));
            return E.and((Expression)AggregationPredicates.isNotNull((Expression)property, fields.get(this.key)), (Expression)E.cmpLe((Expression)property, (Expression)E.value((Object)AggregationPredicates.toInternalValue(fields, this.key, this.value))));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateLe that = (PredicateLe)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.key + "<=" + this.value;
        }
    }

    public static final class PredicateNotEq
    implements AggregationPredicate {
        final String key;
        final Object value;

        private PredicateNotEq(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public AggregationPredicate simplify() {
            return this;
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.singleton(this.key);
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            Variable property = E.property((Expression)record, (String)this.key.replace('.', '$'));
            Object internalValue = AggregationPredicates.toInternalValue(fields, this.key, this.value);
            FieldType fieldType = fields.get(this.key);
            return internalValue == null ? AggregationPredicates.isNotNull((Expression)property, fieldType) : E.or((Expression)AggregationPredicates.isNull((Expression)property, fieldType), (Expression)E.cmpNe((Expression)property, (Expression)E.value((Object)internalValue)));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateNotEq that = (PredicateNotEq)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.key + "!=" + this.value;
        }
    }

    public static final class PredicateEq
    implements AggregationPredicate {
        final String key;
        final Object value;

        private PredicateEq(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public AggregationPredicate simplify() {
            return this;
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.singleton(this.key);
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.singletonMap(this.key, this.value);
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            Variable property = E.property((Expression)record, (String)this.key.replace('.', '$'));
            Object internalValue = AggregationPredicates.toInternalValue(fields, this.key, this.value);
            return internalValue == null ? AggregationPredicates.isNull((Expression)property, fields.get(this.key)) : E.and((Expression)AggregationPredicates.isNotNull((Expression)property, fields.get(this.key)), (Expression)E.cmpEq((Expression)property, (Expression)E.value((Object)internalValue)));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateEq that = (PredicateEq)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.key + '=' + this.value;
        }
    }

    public static final class PredicateNot
    implements AggregationPredicate {
        private final AggregationPredicate predicate;

        private PredicateNot(AggregationPredicate predicate) {
            this.predicate = predicate;
        }

        public AggregationPredicate getPredicate() {
            return this.predicate;
        }

        @Override
        public AggregationPredicate simplify() {
            if (this.predicate instanceof PredicateNot) {
                return ((PredicateNot)this.predicate).predicate.simplify();
            }
            if (this.predicate instanceof PredicateEq) {
                return new PredicateNotEq(((PredicateEq)this.predicate).key, ((PredicateEq)this.predicate).value);
            }
            if (this.predicate instanceof PredicateNotEq) {
                return new PredicateEq(((PredicateNotEq)this.predicate).key, ((PredicateNotEq)this.predicate).value);
            }
            return AggregationPredicates.not(this.predicate.simplify());
        }

        @Override
        public Set<String> getDimensions() {
            return this.predicate.getDimensions();
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            return E.not((Expression)this.predicate.createPredicate(record, fields));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateNot that = (PredicateNot)o;
            return this.predicate.equals(that.predicate);
        }

        @Override
        public int hashCode() {
            return this.predicate.hashCode();
        }

        public String toString() {
            return "NOT " + this.predicate;
        }
    }

    public static final class PredicateAlwaysTrue
    implements AggregationPredicate {
        private static final PredicateAlwaysTrue instance = new PredicateAlwaysTrue();

        private PredicateAlwaysTrue() {
        }

        @Override
        public AggregationPredicate simplify() {
            return this;
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.emptySet();
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            return E.alwaysTrue();
        }

        public String toString() {
            return "TRUE";
        }
    }

    public static final class PredicateAlwaysFalse
    implements AggregationPredicate {
        private static final PredicateAlwaysFalse instance = new PredicateAlwaysFalse();

        private PredicateAlwaysFalse() {
        }

        @Override
        public AggregationPredicate simplify() {
            return this;
        }

        @Override
        public Set<String> getDimensions() {
            return Collections.emptySet();
        }

        @Override
        public Map<String, Object> getFullySpecifiedDimensions() {
            return Collections.emptyMap();
        }

        @Override
        public Expression createPredicate(Expression record, Map<String, FieldType> fields) {
            return E.alwaysFalse();
        }

        public String toString() {
            return "FALSE";
        }
    }

    @FunctionalInterface
    public static interface PredicateSimplifier<L extends AggregationPredicate, R extends AggregationPredicate> {
        public AggregationPredicate simplifyAnd(L var1, R var2);
    }

    private static class PredicateSimplifierKey<L extends AggregationPredicate, R extends AggregationPredicate> {
        private final Class<L> leftType;
        private final Class<R> rightType;

        private PredicateSimplifierKey(Class<L> leftType, Class<R> rightType) {
            this.leftType = leftType;
            this.rightType = rightType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateSimplifierKey that = (PredicateSimplifierKey)o;
            if (!this.leftType.equals(that.leftType)) {
                return false;
            }
            return this.rightType.equals(that.rightType);
        }

        public int hashCode() {
            int result = this.leftType.hashCode();
            result = 31 * result + this.rightType.hashCode();
            return result;
        }
    }

    private static final class E
    extends Expressions {
        private E() {
        }
    }
}

