/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation;

import io.activej.aggregation.AggregationPredicate;
import io.activej.aggregation.AggregationPredicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class AggregationQuery {
    private final List<String> keys = new ArrayList<String>();
    private final List<String> measures = new ArrayList<String>();
    private AggregationPredicate predicate = AggregationPredicates.alwaysTrue();

    public static AggregationQuery create() {
        return new AggregationQuery();
    }

    public static AggregationQuery create(List<String> keys, List<String> measures) {
        return new AggregationQuery(keys, measures);
    }

    public static AggregationQuery create(List<String> keys, List<String> measures, AggregationPredicate predicate) {
        return new AggregationQuery(keys, measures, predicate);
    }

    private AggregationQuery() {
    }

    private AggregationQuery(List<String> keys, List<String> measures) {
        this.keys.addAll(keys);
        this.measures.addAll(measures);
    }

    private AggregationQuery(List<String> keys, List<String> measures, AggregationPredicate predicate) {
        this.keys.addAll(keys);
        this.measures.addAll(measures);
        this.predicate = predicate;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public List<String> getMeasures() {
        return Collections.unmodifiableList(this.measures);
    }

    public Set<String> getAllKeys() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.keys);
        result.addAll(this.predicate.getDimensions());
        return result;
    }

    public AggregationPredicate getPredicate() {
        return this.predicate;
    }

    public AggregationQuery withKey(String key) {
        this.keys.add(key);
        return this;
    }

    public AggregationQuery withKeys(List<String> keys) {
        this.keys.addAll(keys);
        return this;
    }

    public AggregationQuery withKeys(String ... keys) {
        this.keys.addAll(Arrays.asList(keys));
        return this;
    }

    public AggregationQuery withMeasures(List<String> fields) {
        this.measures.addAll(fields);
        return this;
    }

    public AggregationQuery withMeasures(String ... fields) {
        this.measures.addAll(Arrays.asList(fields));
        return this;
    }

    public AggregationQuery withMeasure(String field) {
        this.measures.add(field);
        return this;
    }

    public AggregationQuery withPredicate(AggregationPredicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public AggregationQuery withPredicates(List<AggregationPredicate> predicates) {
        this.predicate = AggregationPredicates.and(predicates);
        return this;
    }

    public String toString() {
        return "AggregationQuery{keys=" + this.keys + ", fields=" + this.measures + ", predicate=" + this.predicate + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationQuery query = (AggregationQuery)o;
        return this.keys.equals(query.keys) && this.measures.equals(query.measures) && this.predicate.equals(query.predicate);
    }

    public int hashCode() {
        int result = this.keys.hashCode();
        result = 31 * result + this.measures.hashCode();
        result = 31 * result + this.predicate.hashCode();
        return result;
    }
}

