/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation;

import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredInput;
import io.activej.codec.StructuredOutput;
import io.activej.common.exception.MalformedDataException;

public interface ChunkIdCodec<C>
extends StructuredCodec<C> {
    public String toFileName(C var1);

    public C fromFileName(String var1) throws MalformedDataException;

    public void encode(StructuredOutput var1, C var2);

    public C decode(StructuredInput var1) throws MalformedDataException;

    public static ChunkIdCodec<Long> ofLong() {
        return new ChunkIdCodec<Long>(){

            @Override
            public String toFileName(Long chunkId) {
                return chunkId.toString();
            }

            @Override
            public Long fromFileName(String chunkFileName) throws MalformedDataException {
                try {
                    return Long.parseLong(chunkFileName);
                }
                catch (NumberFormatException e) {
                    throw new MalformedDataException((Throwable)e);
                }
            }

            @Override
            public void encode(StructuredOutput out, Long value) {
                out.writeLong(value.longValue());
            }

            @Override
            public Long decode(StructuredInput in) throws MalformedDataException {
                return in.readLong();
            }
        };
    }

    public static ChunkIdCodec<String> ofString() {
        return new ChunkIdCodec<String>(){

            @Override
            public String toFileName(String chunkId) {
                return chunkId;
            }

            @Override
            public String fromFileName(String chunkFileName) {
                return chunkFileName;
            }

            @Override
            public void encode(StructuredOutput out, String value) {
                out.writeString(value);
            }

            @Override
            public String decode(StructuredInput in) throws MalformedDataException {
                return in.readString();
            }
        };
    }
}

