/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation;

import io.activej.common.Checks;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PrimaryKey
implements Comparable<PrimaryKey> {
    private static final boolean CHECK = Checks.isEnabled(PrimaryKey.class);
    private final Object[] values;

    private PrimaryKey(Object[] values) {
        this.values = values;
    }

    public static PrimaryKey ofList(List<Object> values) {
        return new PrimaryKey(values.toArray(new Object[0]));
    }

    public static PrimaryKey ofObject(Object object, List<String> keys) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : keys) {
            try {
                Field field = object.getClass().getField(key);
                Object value = field.get(object);
                values.add(value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return PrimaryKey.ofList(values);
    }

    public static PrimaryKey ofArray(Object ... values) {
        return new PrimaryKey(values);
    }

    public Object get(int index) {
        return this.values[index];
    }

    public PrimaryKey prefix(int size) {
        Object[] newValues = new Object[size];
        System.arraycopy(this.values, 0, newValues, 0, size);
        return PrimaryKey.ofArray(newValues);
    }

    public List<Object> values() {
        return Collections.unmodifiableList(Arrays.asList(this.values));
    }

    public Object[] getArray() {
        return this.values;
    }

    public int size() {
        return this.values.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean equals(Object o) {
        PrimaryKey that = (PrimaryKey)o;
        if (CHECK) {
            Checks.checkArgument((this.values.length == that.values.length ? 1 : 0) != 0);
        }
        for (int i = 0; i < this.values.length; ++i) {
            Object thisKey = this.values[i];
            Object thatKey = that.values[i];
            if (CHECK) {
                Checks.checkState((thisKey != null && thatKey != null ? 1 : 0) != 0);
            }
            if (thisKey.equals(thatKey)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public int compareTo(@NotNull PrimaryKey o) {
        if (CHECK) {
            Checks.checkArgument((this.values.length == o.values.length ? 1 : 0) != 0);
        }
        for (int i = 0; i < this.values.length; ++i) {
            int result;
            Object thisKey = this.values[i];
            Object thatKey = o.values[i];
            if (CHECK) {
                Checks.checkState((thisKey != null && thatKey != null ? 1 : 0) != 0);
            }
            if ((result = ((Comparable)thisKey).compareTo(thatKey)) == 0) continue;
            return result;
        }
        return 0;
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

