/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation;

import io.activej.aggregation.AggregationChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class QueryPlan {
    private final List<Sequence> sequences;

    public QueryPlan(@NotNull List<Sequence> sequences) {
        this.sequences = sequences;
    }

    public List<Sequence> getSequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nSequences (").append(this.sequences.size()).append("): ");
        for (int i = 0; i < this.sequences.size(); ++i) {
            sb.append('\n').append(i + 1).append(" (").append(this.sequences.get(i).chunks.size()).append("). ").append(this.sequences.get(i)).append(' ');
        }
        return sb.toString();
    }

    public static class Sequence {
        private final List<String> queryFields;
        private final Set<String> chunksFields = new LinkedHashSet<String>();
        private final List<AggregationChunk> chunks = new ArrayList<AggregationChunk>();

        public Sequence(List<String> queryFields) {
            this.queryFields = queryFields;
        }

        public List<String> getQueryFields() {
            return Collections.unmodifiableList(this.queryFields);
        }

        public Set<String> getChunksFields() {
            return Collections.unmodifiableSet(this.chunksFields);
        }

        public List<AggregationChunk> getChunks() {
            return Collections.unmodifiableList(this.chunks);
        }

        public void add(AggregationChunk chunk) {
            this.chunks.add(chunk);
            this.chunksFields.addAll(chunk.getMeasures());
        }

        public String toString() {
            return this.chunks.stream().map(AggregationChunk::getChunkId).map(Object::toString).collect(Collectors.joining(",", "[", "]"));
        }
    }
}

