/*
 * Decompiled with CFR 0.152.
 */
package io.activej.aggregation.ot;

import io.activej.aggregation.AggregationChunk;
import io.activej.common.collection.CollectionUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class AggregationDiff {
    private final Set<AggregationChunk> addedChunks;
    private final Set<AggregationChunk> removedChunks;

    private AggregationDiff(Set<AggregationChunk> addedChunks, Set<AggregationChunk> removedChunks) {
        this.addedChunks = addedChunks;
        this.removedChunks = removedChunks;
    }

    public static AggregationDiff of(@NotNull Set<AggregationChunk> addedChunks, @NotNull Set<AggregationChunk> removedChunks) {
        return new AggregationDiff(addedChunks, removedChunks);
    }

    public static AggregationDiff of(Set<AggregationChunk> addedChunks) {
        return AggregationDiff.of(addedChunks, Collections.emptySet());
    }

    public static AggregationDiff empty() {
        return new AggregationDiff(Collections.emptySet(), Collections.emptySet());
    }

    public Set<AggregationChunk> getAddedChunks() {
        return this.addedChunks;
    }

    public Set<AggregationChunk> getRemovedChunks() {
        return this.removedChunks;
    }

    public AggregationDiff inverse() {
        return new AggregationDiff(this.removedChunks, this.addedChunks);
    }

    public boolean isEmpty() {
        return this.addedChunks.isEmpty() && this.removedChunks.isEmpty();
    }

    public static AggregationDiff squash(AggregationDiff commit1, AggregationDiff commit2) {
        LinkedHashSet<AggregationChunk> addedChunks1 = new LinkedHashSet<AggregationChunk>(commit1.addedChunks);
        addedChunks1.removeAll(commit2.removedChunks);
        LinkedHashSet<AggregationChunk> addedChunks2 = new LinkedHashSet<AggregationChunk>(commit2.addedChunks);
        addedChunks2.removeAll(commit1.removedChunks);
        Set addedChunks = CollectionUtils.union(addedChunks1, addedChunks2);
        LinkedHashSet<AggregationChunk> removedChunks1 = new LinkedHashSet<AggregationChunk>(commit1.removedChunks);
        removedChunks1.removeAll(commit2.addedChunks);
        LinkedHashSet<AggregationChunk> removedChunks2 = new LinkedHashSet<AggregationChunk>(commit2.removedChunks);
        removedChunks2.removeAll(commit1.addedChunks);
        Set removedChunks = CollectionUtils.union(removedChunks1, removedChunks2);
        return AggregationDiff.of(addedChunks, removedChunks);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationDiff that = (AggregationDiff)o;
        if (!Objects.equals(this.addedChunks, that.addedChunks)) {
            return false;
        }
        return Objects.equals(this.removedChunks, that.removedChunks);
    }

    public int hashCode() {
        int result = this.addedChunks != null ? this.addedChunks.hashCode() : 0;
        result = 31 * result + (this.removedChunks != null ? this.removedChunks.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{addedChunks:" + this.addedChunks.size() + ", removedChunks:" + this.removedChunks.size() + '}';
    }
}

