/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.binary;

import io.activej.async.function.AsyncSupplier;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.supplier.ChannelSupplier;
import io.activej.promise.Promise;
import io.activej.reactor.Reactor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static OutputStream channelConsumerAsOutputStream(final Reactor reactor, final ChannelConsumer<ByteBuf> channelConsumer) {
        return new OutputStream(){
            private boolean isClosed;

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (this.isClosed) {
                    throw new IOException("Stream Closed");
                }
                Utils.submit(reactor, () -> channelConsumer.accept(ByteBuf.wrap((byte[])b, (int)off, (int)(off + len))), this);
            }

            @Override
            public void close() throws IOException {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                Utils.submit(reactor, () -> channelConsumer.acceptEndOfStream().whenComplete(() -> ((ChannelConsumer)channelConsumer).close()), this);
            }
        };
    }

    public static InputStream channelSupplierAsInputStream(final Reactor reactor, final ChannelSupplier<ByteBuf> channelSupplier) {
        return new InputStream(){
            @Nullable
            private ByteBuf current = null;
            private boolean isClosed;
            private boolean isEOS;

            @Override
            public int read() throws IOException {
                return this.doRead(ByteBuf::readByte);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return this.doRead(buf -> buf.read(b, off, Math.min(buf.readRemaining(), len)));
            }

            private int doRead(ToIntFunction<ByteBuf> reader) throws IOException {
                if (this.isClosed) {
                    throw new IOException("Stream Closed");
                }
                if (this.isEOS) {
                    return -1;
                }
                ByteBuf peeked = this.current;
                if (peeked == null) {
                    ByteBuf buf;
                    do {
                        if ((buf = (ByteBuf)Utils.submit(reactor, channelSupplier::get, this)) != null) continue;
                        this.isEOS = true;
                        return -1;
                    } while (!buf.canRead());
                    peeked = buf;
                }
                int result = reader.applyAsInt(peeked);
                if (peeked.canRead()) {
                    this.current = peeked;
                } else {
                    this.current = null;
                    peeked.recycle();
                }
                return result;
            }

            @Override
            public void close() throws IOException {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                this.current = (ByteBuf)io.activej.common.Utils.nullify((Object)this.current, ByteBuf::recycle);
                Utils.submit(reactor, () -> {
                    channelSupplier.close();
                    return Promise.complete();
                }, this);
            }
        };
    }

    private static <T> T submit(Reactor reactor, AsyncSupplier<T> supplier, Closeable closeable) throws IOException {
        CompletableFuture future = reactor.submit(() -> supplier.get());
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            closeable.close();
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            closeable.close();
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Exception) {
                throw new IOException(cause);
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static class IntByteScanner
    implements ByteBufs.ByteScanner {
        private int value;

        public boolean consume(int index, byte b) {
            this.value = this.value << 8 | b & 0xFF;
            return index == 3;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class VarIntByteScanner
    implements ByteBufs.ByteScanner {
        private int result;

        public boolean consume(int index, byte b) throws MalformedDataException {
            this.result = (index == 0 ? 0 : this.result) | (b & 0x7F) << index * 7;
            if ((b & 0x80) == 0) {
                return true;
            }
            if (index == 4) {
                throw new InvalidSizeException("VarInt is too long for a 32-bit integer");
            }
            return false;
        }

        public int getResult() {
            return this.result;
        }
    }
}

