/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.binary.decoder.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.MalformedDataException;
import io.activej.csp.binary.decoder.ByteBufsDecoder;
import org.jetbrains.annotations.Nullable;

public class OfByteTerminated
implements ByteBufsDecoder<ByteBuf> {
    public final byte terminator;
    public final int maxSize;

    public OfByteTerminated(byte terminator, int maxSize) {
        this.terminator = terminator;
        this.maxSize = maxSize;
    }

    @Override
    @Nullable
    public ByteBuf tryDecode(ByteBufs bufs) throws MalformedDataException {
        int bytes = bufs.scanBytes((index, nextByte) -> {
            if (nextByte == this.terminator) {
                return true;
            }
            if (index == this.maxSize - 1) {
                throw new MalformedDataException("No terminator byte is found in " + this.maxSize + " bytes");
            }
            return false;
        });
        if (bytes == 0) {
            return null;
        }
        ByteBuf buf = bufs.takeExactSize(bytes);
        buf.moveTail(-1);
        return buf;
    }
}

