/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.consumer.impl;

import io.activej.common.recycle.Recyclers;
import io.activej.csp.consumer.AbstractChannelConsumer;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.promise.Promise;
import org.jetbrains.annotations.Nullable;

public final class OfPromise<T>
extends AbstractChannelConsumer<T> {
    public final Promise<? extends ChannelConsumer<T>> promise;
    @Nullable
    public ChannelConsumer<T> consumer;

    public OfPromise(Promise<? extends ChannelConsumer<T>> promise) {
        this.promise = promise;
    }

    @Override
    protected Promise<Void> doAccept(T value) {
        if (this.consumer != null) {
            return this.consumer.accept(value);
        }
        return this.promise.then(consumer -> {
            this.consumer = consumer;
            return consumer.accept(value);
        }, e -> {
            Recyclers.recycle((Object)value);
            return Promise.ofException((Exception)e);
        });
    }

    protected void onClosed(Exception e) {
        this.promise.whenResult(supplier -> supplier.closeEx(e));
    }
}

