/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frame.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.builder.AbstractBuilder;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.UnknownFormatException;
import io.activej.csp.binary.Utils;
import io.activej.csp.process.frame.BlockDecoder;
import io.activej.csp.process.frame.BlockEncoder;
import io.activej.csp.process.frame.FrameFormat;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.jetbrains.annotations.Nullable;

public final class LZ4
implements FrameFormat {
    public static final boolean CHECKS = Checks.isEnabled(LZ4.class);
    public static final MemSize MAX_BLOCK_SIZE = ApplicationSettings.getMemSize(LZ4.class, (String)"maxBlockSize", (MemSize)MemSize.megabytes((long)256L));
    static final byte[] MAGIC = new byte[]{76, 90, 52, 1};
    static final byte[] LAST_BLOCK_BYTES = new byte[]{-1, -1, -1, -1};
    static final byte[] MAGIC_AND_LAST_BLOCK_BYTES;
    static final int MAGIC_LENGTH;
    static final int COMPRESSED_LENGTH_MASK = Integer.MAX_VALUE;
    static final byte END_OF_BLOCK = 1;
    public LZ4Factory factory;
    public int compressionLevel;

    public LZ4(LZ4Factory factory, int compressionLevel) {
        this.factory = factory;
        this.compressionLevel = compressionLevel;
    }

    public static LZ4 create() {
        return (LZ4)LZ4.builder().build();
    }

    public static Builder builder() {
        return new LZ4(LZ4Factory.fastestInstance(), 0).new Builder();
    }

    @Override
    public BlockEncoder createEncoder() {
        LZ4Compressor compressor = this.compressionLevel == 0 ? this.factory.fastCompressor() : (this.compressionLevel == -1 ? this.factory.highCompressor() : this.factory.highCompressor(this.compressionLevel));
        return new Encoder(compressor);
    }

    @Override
    public BlockDecoder createDecoder() {
        return new Decoder(this.factory.fastDecompressor());
    }

    static {
        MAGIC_LENGTH = MAGIC.length;
        MAGIC_AND_LAST_BLOCK_BYTES = new byte[MAGIC.length + LAST_BLOCK_BYTES.length];
        System.arraycopy(MAGIC, 0, MAGIC_AND_LAST_BLOCK_BYTES, 0, MAGIC.length);
        System.arraycopy(LAST_BLOCK_BYTES, 0, MAGIC_AND_LAST_BLOCK_BYTES, MAGIC.length, LAST_BLOCK_BYTES.length);
    }

    public final class Builder
    extends AbstractBuilder<Builder, LZ4> {
        private Builder() {
        }

        public Builder withLZ4Factory(LZ4Factory factory) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            LZ4.this.factory = factory;
            return this;
        }

        public Builder withHighCompression() {
            Builder.checkNotBuilt((AbstractBuilder)this);
            LZ4.this.compressionLevel = -1;
            return this;
        }

        public Builder withCompressionLevel(int compressionLevel) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            Checks.checkArgument((compressionLevel >= -1 ? 1 : 0) != 0);
            LZ4.this.compressionLevel = compressionLevel;
            return this;
        }

        protected LZ4 doBuild() {
            return LZ4.this;
        }
    }

    public static final class Encoder
    implements BlockEncoder {
        private final LZ4Compressor compressor;
        private boolean writeHeader = true;

        Encoder(LZ4Compressor compressor) {
            this.compressor = compressor;
        }

        @Override
        public void reset() {
            this.writeHeader = true;
        }

        @Override
        public ByteBuf encode(ByteBuf inputBuf) {
            int compressedLength;
            int headerSize = this.writeHeader ? MAGIC_LENGTH : 0;
            this.writeHeader = false;
            int off = inputBuf.head();
            int len = inputBuf.readRemaining();
            byte[] array = inputBuf.array();
            if (CHECKS) {
                Checks.checkArgument((len != 0 ? 1 : 0) != 0, (Object)"Encoding empty buf");
            }
            ByteBuf outputBuf = ByteBufPool.allocate((int)(headerSize + 8 + this.compressor.maxCompressedLength(len) + 1));
            if (headerSize != 0) {
                System.arraycopy(MAGIC, 0, outputBuf.array(), 0, MAGIC_LENGTH);
                outputBuf.moveTail(MAGIC_LENGTH);
            }
            if ((compressedLength = this.compressor.compress(array, off, len, outputBuf.array(), headerSize + 8)) + 4 < len) {
                outputBuf.writeInt(compressedLength | Integer.MIN_VALUE);
                outputBuf.writeInt(len);
                outputBuf.moveTail(compressedLength);
            } else {
                outputBuf.writeInt(len);
                System.arraycopy(array, off, outputBuf.array(), outputBuf.tail(), len);
                outputBuf.moveTail(len);
            }
            outputBuf.put((byte)1);
            return outputBuf;
        }

        @Override
        public ByteBuf encodeEndOfStreamBlock() {
            if (!this.writeHeader) {
                return ByteBuf.wrapForReading((byte[])LAST_BLOCK_BYTES);
            }
            this.writeHeader = false;
            return ByteBuf.wrapForReading((byte[])MAGIC_AND_LAST_BLOCK_BYTES);
        }
    }

    public static final class Decoder
    implements BlockDecoder {
        private static final int LAST_BLOCK_INT = -1;
        private final LZ4FastDecompressor decompressor;
        private boolean readHeader = true;
        private final Utils.IntByteScanner intScanner = new Utils.IntByteScanner();

        Decoder(LZ4FastDecompressor decompressor) {
            this.decompressor = decompressor;
        }

        @Override
        public void reset() {
            this.readHeader = true;
        }

        @Override
        @Nullable
        public ByteBuf decode(ByteBufs bufs) throws MalformedDataException {
            if (this.readHeader) {
                if (!this.readHeader(bufs)) {
                    return null;
                }
                this.readHeader = false;
            }
            if (bufs.scanBytes((ByteBufs.ByteScanner)this.intScanner) == 0) {
                return null;
            }
            int compressedSize = this.intScanner.getValue();
            if (compressedSize == -1) {
                bufs.skip(4);
                return END_OF_STREAM;
            }
            if (compressedSize >= 0) {
                if (!bufs.hasRemainingBytes(4 + compressedSize + 1)) {
                    return null;
                }
                bufs.skip(4);
                ByteBuf result = bufs.takeExactSize(compressedSize + 1);
                if (result.at(result.tail() - 1) != 1) {
                    throw new MalformedDataException("Block does not end with special byte '1'");
                }
                result.moveTail(-1);
                return result;
            }
            return this.decompress(bufs, compressedSize & Integer.MAX_VALUE);
        }

        @Override
        public boolean ignoreMissingEndOfStreamBlock() {
            return false;
        }

        private boolean readHeader(ByteBufs bufs) throws MalformedDataException {
            return bufs.consumeBytes((index, value) -> {
                if (value != MAGIC[index]) {
                    throw new UnknownFormatException("Expected stream to start with bytes: " + Arrays.toString(MAGIC));
                }
                return index == MAGIC_LENGTH - 1;
            }) != 0;
        }

        @Nullable
        private ByteBuf decompress(ByteBufs bufs, int compressedSize) throws MalformedDataException {
            ByteBuf compressedBuf;
            if (!bufs.hasRemainingBytes(8 + compressedSize + 1)) {
                return null;
            }
            bufs.consumeBytes(4, (ByteBufs.ByteScanner)this.intScanner);
            int originalSize = this.intScanner.getValue();
            if (originalSize < 0 || originalSize > MAX_BLOCK_SIZE.toInt()) {
                throw new InvalidSizeException("Size (" + originalSize + ") of block is either negative or exceeds max block size (" + MAX_BLOCK_SIZE + ")");
            }
            ByteBuf firstBuf = bufs.peekBuf();
            assert (firstBuf != null);
            ByteBuf byteBuf = compressedBuf = firstBuf.readRemaining() >= compressedSize + 1 ? firstBuf : bufs.takeExactSize(compressedSize + 1);
            if (compressedBuf.at(compressedBuf.head() + compressedSize) != 1) {
                throw new MalformedDataException("Block does not end with special byte '1'");
            }
            ByteBuf buf = ByteBufPool.allocate((int)originalSize);
            try {
                int readBytes = this.decompressor.decompress(compressedBuf.array(), compressedBuf.head(), buf.array(), 0, originalSize);
                if (readBytes != compressedSize) {
                    buf.recycle();
                    throw new InvalidSizeException("Actual size of decompressed data does not equal expected size of decompressed data");
                }
                buf.tail(originalSize);
            }
            catch (LZ4Exception e) {
                buf.recycle();
                throw new MalformedDataException("Failed to decompress data", (Throwable)e);
            }
            if (compressedBuf != firstBuf) {
                compressedBuf.recycle();
            } else {
                bufs.skip(compressedSize + 1);
            }
            return buf;
        }
    }
}

