/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.transformer.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.csp.process.transformer.AbstractChannelTransformer;
import io.activej.promise.Promise;
import io.activej.promise.Promises;

public final class ByteChunker
extends AbstractChannelTransformer<ByteChunker, ByteBuf, ByteBuf> {
    public final ByteBufs bufs = new ByteBufs();
    public final int minChunkSize;
    public final int maxChunkSize;

    public ByteChunker(int minChunkSize, int maxChunkSize) {
        this.minChunkSize = (Integer)Checks.checkArgument((Object)minChunkSize, minSize -> minSize > 0, (Object)"Minimal chunk size should be greater than 0");
        this.maxChunkSize = (Integer)Checks.checkArgument((Object)maxChunkSize, maxSize -> maxSize >= minChunkSize, (Object)"Maximal chunk size cannot be less than minimal chunk size");
    }

    @Override
    protected Promise<Void> onItem(ByteBuf item) {
        this.bufs.add(item);
        return Promises.repeat(() -> {
            if (!this.bufs.hasRemainingBytes(this.minChunkSize)) {
                return Promise.of((Object)false);
            }
            int exactSize = 0;
            for (int i = 0; i != this.bufs.remainingBufs() && (exactSize += this.bufs.peekBuf(i).readRemaining()) < this.minChunkSize; ++i) {
            }
            return this.send(this.bufs.takeExactSize(Math.min(exactSize, this.maxChunkSize))).map($ -> true);
        });
    }

    @Override
    protected Promise<Void> onProcessFinish() {
        return (this.bufs.hasRemaining() ? this.send(this.bufs.takeRemaining()) : Promise.complete()).then(() -> this.sendEndOfStream());
    }

    @Override
    protected void onCleanup() {
        this.bufs.recycle();
    }
}

