/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.transformer.impl;

import io.activej.bytebuf.ByteBuf;
import io.activej.csp.process.transformer.AbstractChannelTransformer;
import io.activej.promise.Promise;

public final class ByteRanger
extends AbstractChannelTransformer<ByteRanger, ByteBuf, ByteBuf> {
    public final long offset;
    public final long endOffset;
    public long position;

    public ByteRanger(long offset, long length) {
        this.offset = offset;
        this.endOffset = length;
    }

    @Override
    protected Promise<Void> onItem(ByteBuf item) {
        int size = item.readRemaining();
        long oldPos = this.position;
        this.position += (long)size;
        if (oldPos > this.endOffset || this.position <= this.offset) {
            item.recycle();
            return Promise.complete();
        }
        if (oldPos < this.offset) {
            item.moveHead((int)(this.offset - oldPos));
        }
        if (this.position > this.endOffset) {
            item.moveTail((int)(this.endOffset - this.position));
        }
        return this.send(item);
    }
}

