/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.supplier;

import io.activej.async.process.AsyncCloseable;
import io.activej.async.process.AsyncExecutor;
import io.activej.common.collection.Try;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.recycle.Recyclers;
import io.activej.csp.ChannelInput;
import io.activej.csp.consumer.ChannelConsumer;
import io.activej.csp.consumer.ChannelConsumers;
import io.activej.csp.process.transformer.ChannelSupplierTransformer;
import io.activej.csp.supplier.AbstractChannelSupplier;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import io.activej.promise.SettableCallback;
import io.activej.promise.SettablePromise;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public interface ChannelSupplier<T>
extends AsyncCloseable {
    public Promise<T> get();

    default public <R> R transformWith(ChannelSupplierTransformer<T, R> fn) {
        return fn.transform(this);
    }

    default public ChannelSupplier<T> async() {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return ChannelSupplier.this.get().async();
            }
        };
    }

    default public ChannelSupplier<T> withExecutor(final AsyncExecutor executor) {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return executor.execute(ChannelSupplier.this::get);
            }
        };
    }

    default public ChannelSupplier<T> peek(final Consumer<? super T> fn) {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return ChannelSupplier.this.get().whenResult(v -> {
                    if (v != null) {
                        fn.accept(v);
                    }
                });
            }
        };
    }

    default public <V> ChannelSupplier<V> map(final FunctionEx<? super T, ? extends V> fn) {
        return new AbstractChannelSupplier<V>(this){

            @Override
            protected Promise<V> doGet() {
                return ChannelSupplier.this.get().map(t -> {
                    if (t == null) {
                        return null;
                    }
                    try {
                        return fn.apply(t);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)fn);
                        ChannelSupplier.this.closeEx(ex);
                        throw ex;
                    }
                });
            }
        };
    }

    default public <V> ChannelSupplier<V> mapAsync(final Function<? super T, Promise<V>> fn) {
        return new AbstractChannelSupplier<V>(this){

            @Override
            protected Promise<V> doGet() {
                return ChannelSupplier.this.get().then(value -> value != null ? (Promise)fn.apply(value) : Promise.of(null));
            }
        };
    }

    default public ChannelSupplier<T> filter(final Predicate<? super T> predicate) {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                Promise promise;
                while ((promise = ChannelSupplier.this.get()).isResult()) {
                    Object value2 = promise.getResult();
                    if (value2 == null || predicate.test(value2)) {
                        return promise;
                    }
                    Recyclers.recycle((Object)value2);
                }
                return promise.then(value -> {
                    if (value == null || predicate.test(value)) {
                        return Promise.of((Object)value);
                    }
                    Recyclers.recycle((Object)value);
                    return this.get();
                });
            }
        };
    }

    default public ChannelSupplier<T> until(final Predicate<? super T> predicate) {
        return new AbstractChannelSupplier<T>(this){
            boolean stop;
            {
                super(closeable);
                this.stop = false;
            }

            @Override
            protected Promise<T> doGet() {
                if (this.stop) {
                    return Promise.of(null);
                }
                return ChannelSupplier.this.get().map(value -> {
                    if (value == null) {
                        return null;
                    }
                    if (predicate.test(value)) {
                        this.stop = true;
                    }
                    return value;
                });
            }
        };
    }

    default public ChannelSupplier<T> lenient() {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return ChannelSupplier.this.get().map((value, e) -> value);
            }
        };
    }

    default public Promise<Void> streamTo(ChannelConsumer<T> consumer) {
        return Promise.ofCallback(cb -> ChannelSupplier.streamToImpl(this, consumer, (SettableCallback<Void>)cb));
    }

    default public Promise<Void> streamTo(Promise<? extends ChannelConsumer<T>> consumer) {
        return this.streamTo(ChannelConsumers.ofPromise(consumer));
    }

    default public Promise<Void> bindTo(ChannelInput<T> to) {
        return to.set(this);
    }

    default public <A, R> Promise<R> toCollector(Collector<T, A, R> collector) {
        return ChannelSupplier.collect(this, collector.supplier().get(), BiConsumerEx.of(collector.accumulator()), FunctionEx.of(collector.finisher()));
    }

    default public Promise<List<T>> toList() {
        return this.toCollector(Collectors.toList());
    }

    default public ChannelSupplier<T> withEndOfStream(UnaryOperator<Promise<Void>> fn) {
        final SettablePromise endOfStream = new SettablePromise();
        final Promise newEndOfStream = (Promise)fn.apply((Promise<Void>)endOfStream);
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return ChannelSupplier.this.get().then((item, e) -> {
                    if (e == null) {
                        if (item != null) {
                            return Promise.of((Object)item);
                        }
                        endOfStream.trySet(null);
                    } else {
                        endOfStream.trySetException(e);
                    }
                    return newEndOfStream;
                });
            }

            protected void onClosed(Exception e) {
                endOfStream.trySetException(e);
            }
        };
    }

    public static <T, A, R> Promise<R> collect(ChannelSupplier<T> supplier, A initialValue, BiConsumerEx<A, T> accumulator, FunctionEx<A, R> finisher) {
        return Promise.ofCallback(cb -> ChannelSupplier.toCollectorImpl(supplier, initialValue, accumulator, finisher, cb));
    }

    public static <T> Promise<Void> streamTo(Promise<ChannelSupplier<T>> supplier, Promise<ChannelConsumer<T>> consumer) {
        return Promises.toTuple((Promise)supplier.toTry(), (Promise)consumer.toTry()).then(t -> ChannelSupplier.streamTo((Try)t.value1(), (Try)t.value2()));
    }

    public static <T> Promise<Void> streamTo(Try<ChannelSupplier<T>> supplier, Try<ChannelConsumer<T>> consumer) {
        if (supplier.isSuccess() && consumer.isSuccess()) {
            return ((ChannelSupplier)supplier.get()).streamTo((ChannelConsumer)consumer.get());
        }
        Exception exception = new Exception("Channel stream failed");
        supplier.consume(AsyncCloseable::close, exception::addSuppressed);
        consumer.consume(AsyncCloseable::close, exception::addSuppressed);
        return Promise.ofException((Exception)exception);
    }

    private static <T> void streamToImpl(ChannelSupplier<T> supplier, ChannelConsumer<T> consumer, SettableCallback<Void> cb) {
        Object item2;
        Promise<T> supplierPromise;
        while ((supplierPromise = supplier.get()).isResult() && (item2 = supplierPromise.getResult()) != null) {
            Promise<Void> consumerPromise = consumer.accept(item2);
            if (consumerPromise.isResult()) continue;
            consumerPromise.subscribe(($, e) -> {
                if (e == null) {
                    ChannelSupplier.streamToImpl(supplier, consumer, cb);
                } else {
                    supplier.closeEx(e);
                    cb.trySetException(e);
                }
            });
            return;
        }
        supplierPromise.subscribe((item, e1) -> {
            if (e1 == null) {
                consumer.accept(item).subscribe(($, e2) -> {
                    if (e2 == null) {
                        if (item != null) {
                            ChannelSupplier.streamToImpl(supplier, consumer, cb);
                        } else {
                            cb.trySet(null);
                        }
                    } else {
                        supplier.closeEx(e2);
                        cb.trySetException(e2);
                    }
                });
            } else {
                consumer.closeEx(e1);
                cb.trySetException(e1);
            }
        });
    }

    private static <T, A, R> void toCollectorImpl(ChannelSupplier<T> supplier, A accumulatedValue, BiConsumerEx<A, T> accumulator, FunctionEx<A, R> finisher, SettableCallback<R> cb) {
        Object item;
        Promise<T> promise;
        while ((promise = supplier.get()).isResult() && (item = promise.getResult()) != null) {
            try {
                accumulator.accept(accumulatedValue, item);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, cb);
                supplier.closeEx(ex);
                cb.setException(ex);
                return;
            }
        }
        promise.subscribe((value, e) -> {
            if (e == null) {
                if (value != null) {
                    try {
                        accumulator.accept(accumulatedValue, value);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)cb);
                        supplier.closeEx(ex);
                        cb.setException(ex);
                        return;
                    }
                    ChannelSupplier.toCollectorImpl(supplier, accumulatedValue, accumulator, finisher, cb);
                } else {
                    Object result;
                    try {
                        result = finisher.apply(accumulatedValue);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)cb);
                        cb.setException(ex);
                        return;
                    }
                    cb.set(result);
                }
            } else {
                Recyclers.recycle((Object)accumulatedValue);
                cb.setException(e);
            }
        });
    }
}

