/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.supplier.impl;

import io.activej.common.recycle.Recyclers;
import io.activej.csp.supplier.AbstractChannelSupplier;
import io.activej.promise.Promise;
import java.util.Iterator;

public final class OfIterator<T>
extends AbstractChannelSupplier<T> {
    public final Iterator<? extends T> iterator;
    public final boolean ownership;

    public OfIterator(Iterator<? extends T> iterator, boolean ownership) {
        this.iterator = iterator;
        this.ownership = ownership;
    }

    @Override
    protected Promise<T> doGet() {
        return Promise.of(this.iterator.hasNext() ? this.iterator.next() : null);
    }

    protected void onCleanup() {
        if (this.ownership) {
            this.iterator.forEachRemaining(Recyclers::recycle);
        } else {
            Recyclers.recycle(this.iterator);
        }
    }
}

