/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube;

import io.activej.codegen.DefiningClassLoader;
import io.activej.cube.CubeClassLoaderCacheMBean;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CubeClassLoaderCache
implements CubeClassLoaderCacheMBean {
    private final DefiningClassLoader rootClassLoader;
    private final LinkedHashMap<Key, DefiningClassLoader> cache = new LinkedHashMap<Key, DefiningClassLoader>(16, 0.75f, false){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Key, DefiningClassLoader> eldest) {
            return this.size() > CubeClassLoaderCache.this.targetCacheKeys;
        }
    };
    private int targetCacheKeys;
    private int cacheRequests;
    private int cacheMisses;

    private CubeClassLoaderCache(DefiningClassLoader rootClassLoader, int targetCacheKeys) {
        this.rootClassLoader = rootClassLoader;
        this.targetCacheKeys = targetCacheKeys;
    }

    public static CubeClassLoaderCache create(DefiningClassLoader root, int cacheSize) {
        return new CubeClassLoaderCache(root, cacheSize);
    }

    public synchronized DefiningClassLoader getOrCreate(Key key) {
        ++this.cacheRequests;
        return this.cache.computeIfAbsent(key, $ -> {
            ++this.cacheMisses;
            return DefiningClassLoader.create((ClassLoader)this.rootClassLoader);
        });
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
    }

    @Override
    public int getTargetCacheKeys() {
        return this.targetCacheKeys;
    }

    @Override
    public void setTargetCacheKeys(int targetCacheKeys) {
        this.targetCacheKeys = targetCacheKeys;
    }

    @Override
    public synchronized int getDefinedClassesCount() {
        int result = 0;
        for (DefiningClassLoader classLoader : this.cache.values()) {
            result += classLoader.getCachedClassesCount();
        }
        return result;
    }

    @Override
    public synchronized int getDefinedClassesCountMaxPerKey() {
        int result = 0;
        for (DefiningClassLoader classLoader : this.cache.values()) {
            result = Math.max(result, classLoader.getCachedClassesCount());
        }
        return result;
    }

    @Override
    public int getCacheKeys() {
        return this.cache.size();
    }

    @Override
    public int getCacheRequests() {
        return this.cacheRequests;
    }

    @Override
    public int getCacheMisses() {
        return this.cacheMisses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getCacheContents() {
        LinkedHashMap<String, String> map;
        CubeClassLoaderCache cubeClassLoaderCache = this;
        synchronized (cubeClassLoaderCache) {
            map = new LinkedHashMap<String, String>(this.cache.size());
        }
        for (Map.Entry entry : this.cache.entrySet()) {
            map.put(((Key)entry.getKey()).toString(), ((DefiningClassLoader)entry.getValue()).toString());
        }
        return map;
    }

    static final class Key {
        final Set<String> attributes;
        final Set<String> measures;
        final Set<String> filterDimensions;

        Key(Set<String> attributes, Set<String> measures, Set<String> filterDimensions) {
            this.attributes = attributes;
            this.measures = measures;
            this.filterDimensions = filterDimensions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return this.attributes.equals(that.attributes) && this.measures.equals(that.measures) && this.filterDimensions.equals(that.filterDimensions);
        }

        public int hashCode() {
            int result = this.attributes.hashCode();
            result = 31 * result + this.measures.hashCode();
            result = 31 * result + this.filterDimensions.hashCode();
            return result;
        }

        public String toString() {
            return "{" + this.attributes + ", " + this.measures + ", " + this.filterDimensions + '}';
        }
    }
}

