/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube;

import io.activej.codegen.ClassBuilder;
import io.activej.codegen.DefiningClassLoader;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.StoreDef;
import io.activej.cube.Cube;
import io.activej.cube.attributes.AttributeResolver;
import io.activej.cube.ot.CubeDiff;
import io.activej.cube.ot.CubeDiffScheme;
import io.activej.promise.Promise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Utils {
    public static <R> Class<R> createResultClass(Collection<String> attributes, Collection<String> measures, Cube cube, DefiningClassLoader classLoader) {
        ClassBuilder builder = ClassBuilder.create((DefiningClassLoader)classLoader, Object.class, (Class[])new Class[0]);
        builder.withClassKey(new Object[]{new HashSet<String>(attributes), new HashSet<String>(measures)});
        for (String attribute : attributes) {
            builder.withField(attribute.replace('.', '$'), cube.getAttributeInternalType(attribute));
        }
        for (String measure : measures) {
            builder.withField(measure, cube.getMeasureInternalType(measure));
        }
        return builder.build();
    }

    static boolean startsWith(List<String> list, List<String> prefix) {
        if (prefix.size() >= list.size()) {
            return false;
        }
        for (int i = 0; i < prefix.size(); ++i) {
            if (list.get(i).equals(prefix.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <R> Promise<Void> resolveAttributes(List<R> results, AttributeResolver attributeResolver, List<String> recordDimensions, List<String> recordAttributes, Map<String, Object> fullySpecifiedDimensions, Class<R> recordClass, DefiningClassLoader classLoader) {
        Object[] fullySpecifiedDimensionsArray = new Object[recordDimensions.size()];
        for (int i = 0; i < recordDimensions.size(); ++i) {
            String dimension = recordDimensions.get(i);
            if (!fullySpecifiedDimensions.containsKey(dimension)) continue;
            fullySpecifiedDimensionsArray[i] = fullySpecifiedDimensions.get(dimension);
        }
        AttributeResolver.KeyFunction keyFunction = (AttributeResolver.KeyFunction)ClassBuilder.create((DefiningClassLoader)classLoader, AttributeResolver.KeyFunction.class, (Class[])new Class[0]).withClassKey(new Object[]{recordClass, recordDimensions, Arrays.asList(fullySpecifiedDimensionsArray)}).withMethod("extractKey", Expressions.let((Expression)Expressions.arrayNew(Object[].class, (Expression)Expressions.value((Object)recordDimensions.size())), key -> Expressions.sequence(expressions -> {
            for (int i = 0; i < recordDimensions.size(); ++i) {
                String dimension = (String)recordDimensions.get(i);
                expressions.add(Expressions.arraySet((Expression)key, (Expression)Expressions.value((Object)i), (Expression)(fullySpecifiedDimensions.containsKey(dimension) ? Expressions.arrayGet((Expression)Expressions.value((Object)fullySpecifiedDimensionsArray), (Expression)Expressions.value((Object)i)) : Expressions.cast((Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)recordClass), (String)dimension), Object.class))));
            }
            expressions.add(key);
        }))).buildClassAndCreateNewInstance();
        ArrayList<String> resolverAttributes = new ArrayList<String>(attributeResolver.getAttributeTypes().keySet());
        AttributeResolver.AttributesFunction attributesFunction = (AttributeResolver.AttributesFunction)ClassBuilder.create((DefiningClassLoader)classLoader, AttributeResolver.AttributesFunction.class, (Class[])new Class[0]).withClassKey(new Object[]{recordClass, new HashSet<String>(recordAttributes)}).withMethod("applyAttributes", Expressions.sequence(expressions -> {
            for (String attribute : recordAttributes) {
                String attributeName = attribute.substring(attribute.indexOf(46) + 1);
                int resolverAttributeIndex = resolverAttributes.indexOf(attributeName);
                expressions.add(Expressions.set((StoreDef)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), (Class)recordClass), (String)attribute.replace('.', '$')), (Expression)Expressions.arrayGet((Expression)Expressions.arg((int)1), (Expression)Expressions.value((Object)resolverAttributeIndex))));
            }
        })).buildClassAndCreateNewInstance();
        return attributeResolver.resolveAttributes(results, keyFunction, attributesFunction);
    }

    public static <D, C> Set<C> chunksInDiffs(CubeDiffScheme<D> cubeDiffsExtractor, List<? extends D> diffs) {
        return diffs.stream().flatMap(cubeDiffsExtractor::unwrapToStream).flatMap(CubeDiff::addedChunks).map(id -> id).collect(Collectors.toSet());
    }
}

