/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.attributes;

import io.activej.async.service.EventloopService;
import io.activej.common.Utils;
import io.activej.cube.attributes.AbstractAttributeResolver;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.jmx.EventloopJmxBean;
import io.activej.eventloop.schedule.ScheduledRunnable;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxOperation;
import io.activej.jmx.stats.ValueStats;
import io.activej.promise.Promise;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReloadingAttributeResolver<K, A>
extends AbstractAttributeResolver<K, A>
implements EventloopService,
EventloopJmxBean {
    protected final Eventloop eventloop;
    private long timestamp;
    private long reloadPeriod;
    private long retryPeriod = 1000L;
    @Nullable
    private ScheduledRunnable scheduledRunnable;
    private final Map<K, A> cache = new HashMap<K, A>();
    private int reloads;
    private int reloadErrors;
    private int resolveErrors;
    private K lastResolveErrorKey;
    private final ValueStats reloadTime = ValueStats.create((Duration)Duration.ofHours(1L)).withRate("reloads").withUnit("milliseconds");

    protected ReloadingAttributeResolver(Eventloop eventloop) {
        this.eventloop = eventloop;
    }

    @Override
    @Nullable
    protected final A resolveAttributes(K key) {
        A result = this.cache.get(key);
        if (result == null) {
            ++this.resolveErrors;
            this.lastResolveErrorKey = key;
        }
        return result;
    }

    protected abstract Promise<Map<K, A>> reload(long var1);

    private void doReload() {
        ++this.reloads;
        this.scheduledRunnable = (ScheduledRunnable)Utils.nullify((Object)this.scheduledRunnable, ScheduledRunnable::cancel);
        long reloadTimestamp = this.eventloop.currentTimeMillis();
        this.reload(this.timestamp).whenComplete((result, e) -> {
            if (e == null) {
                this.reloadTime.recordValue((int)(this.eventloop.currentTimeMillis() - reloadTimestamp));
                this.cache.putAll((Map<K, A>)result);
                this.timestamp = reloadTimestamp;
                this.scheduleReload(this.reloadPeriod);
            } else {
                ++this.reloadErrors;
                this.scheduleReload(this.retryPeriod);
            }
        });
    }

    private void scheduleReload(long period) {
        this.scheduledRunnable = this.eventloop.delayBackground(period, RunnableWithContext.wrapContext((Object)this, this::doReload));
    }

    @NotNull
    public Eventloop getEventloop() {
        return this.eventloop;
    }

    @NotNull
    public Promise<Void> start() {
        if (this.reloadPeriod == 0L) {
            return Promise.complete();
        }
        long reloadTimestamp = this.eventloop.currentTimeMillis();
        return this.reload(this.timestamp).whenResult(result -> {
            this.reloadTime.recordValue((int)(this.eventloop.currentTimeMillis() - reloadTimestamp));
            this.cache.putAll((Map<K, A>)result);
            this.timestamp = reloadTimestamp;
            this.scheduleReload(this.reloadPeriod);
        }).toVoid();
    }

    @NotNull
    public Promise<Void> stop() {
        this.scheduledRunnable = (ScheduledRunnable)Utils.nullify((Object)this.scheduledRunnable, ScheduledRunnable::cancel);
        return Promise.complete();
    }

    @JmxOperation
    public void reload() {
        this.doReload();
    }

    @JmxAttribute
    public long getReloadPeriod() {
        return this.reloadPeriod;
    }

    @JmxAttribute
    public void setReloadPeriod(long reloadPeriod) {
        this.reloadPeriod = reloadPeriod;
    }

    @JmxAttribute
    public long getRetryPeriod() {
        return this.retryPeriod;
    }

    @JmxAttribute
    public void setRetryPeriod(long retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    @JmxAttribute
    public int getReloads() {
        return this.reloads;
    }

    @JmxAttribute
    public int getReloadErrors() {
        return this.reloadErrors;
    }

    @JmxAttribute
    public int getResolveErrors() {
        return this.resolveErrors;
    }

    @JmxAttribute
    @Nullable
    public String getLastResolveErrorKey() {
        return this.lastResolveErrorKey == null ? null : this.lastResolveErrorKey.toString();
    }

    @JmxAttribute
    public ValueStats getReloadTime() {
        return this.reloadTime;
    }
}

