/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.http;

import io.activej.aggregation.AggregationPredicate;
import io.activej.aggregation.AggregationPredicates;
import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredInput;
import io.activej.codec.StructuredOutput;
import io.activej.codec.registry.CodecFactory;
import io.activej.common.exception.parse.ParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

final class AggregationPredicateCodec
implements StructuredCodec<AggregationPredicate> {
    public static final String EMPTY_STRING = "";
    public static final String SPACES = "\\s+";
    public static final String EQ = "eq";
    public static final String NOT_EQ = "notEq";
    public static final String HAS = "has";
    public static final String GE = "ge";
    public static final String GT = "gt";
    public static final String LE = "le";
    public static final String LT = "lt";
    public static final String IN = "in";
    public static final String BETWEEN = "between";
    public static final String REGEXP = "regexp";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String NOT = "not";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String EQ_SIGN = "=";
    public static final String NOT_EQ_SIGN = "<>";
    public static final String GE_SIGN = ">=";
    public static final String GT_SIGN = ">";
    public static final String LE_SIGN = "<=";
    public static final String LT_SIGN = "<";
    public static final String IN_SIGN = "IN";
    private final Map<String, StructuredCodec<?>> attributeCodecs;

    private AggregationPredicateCodec(Map<String, StructuredCodec<?>> attributeCodecs) {
        this.attributeCodecs = attributeCodecs;
    }

    public static AggregationPredicateCodec create(CodecFactory mapping, Map<String, Type> attributeTypes, Map<String, Type> measureTypes) {
        LinkedHashMap attributeCodecs = new LinkedHashMap();
        for (Map.Entry<String, Type> entry : attributeTypes.entrySet()) {
            attributeCodecs.put(entry.getKey(), mapping.get(entry.getValue()).nullable());
        }
        for (Map.Entry<String, Type> entry : measureTypes.entrySet()) {
            attributeCodecs.put(entry.getKey(), mapping.get(entry.getValue()));
        }
        return new AggregationPredicateCodec(attributeCodecs);
    }

    private void writeEq(StructuredOutput writer, AggregationPredicates.PredicateEq predicate) {
        writer.writeKey(predicate.getKey());
        StructuredCodec<?> codec = this.attributeCodecs.get(predicate.getKey());
        codec.encode(writer, predicate.getValue());
    }

    private void writeNotEq(StructuredOutput writer, AggregationPredicates.PredicateNotEq predicate) {
        writer.writeString(predicate.getKey());
        StructuredCodec<?> codec = this.attributeCodecs.get(predicate.getKey());
        codec.encode(writer, predicate.getValue());
    }

    private void writeGe(StructuredOutput writer, AggregationPredicates.PredicateGe predicate) {
        writer.writeString(predicate.getKey());
        StructuredCodec<?> codec = this.attributeCodecs.get(predicate.getKey());
        codec.encode(writer, (Object)predicate.getValue());
    }

    private void writeGt(StructuredOutput writer, AggregationPredicates.PredicateGt predicate) {
        writer.writeString(predicate.getKey());
        StructuredCodec<?> codec = this.attributeCodecs.get(predicate.getKey());
        codec.encode(writer, (Object)predicate.getValue());
    }

    private void writeLe(StructuredOutput writer, AggregationPredicates.PredicateLe predicate) {
        writer.writeString(predicate.getKey());
        StructuredCodec<?> codec = this.attributeCodecs.get(predicate.getKey());
        codec.encode(writer, predicate.getValue());
    }

    private void writeLt(StructuredOutput writer, AggregationPredicates.PredicateLt predicate) {
        writer.writeString(predicate.getKey());
        StructuredCodec<?> codec = this.attributeCodecs.get(predicate.getKey());
        codec.encode(writer, predicate.getValue());
    }

    private void writeIn(StructuredOutput writer, AggregationPredicates.PredicateIn predicate) {
        writer.writeString(predicate.getKey());
        StructuredCodec<?> codec = this.attributeCodecs.get(predicate.getKey());
        for (Object value : predicate.getValues()) {
            codec.encode(writer, value);
        }
    }

    private void writeBetween(StructuredOutput writer, AggregationPredicates.PredicateBetween predicate) {
        writer.writeString(predicate.getKey());
        StructuredCodec<?> codec = this.attributeCodecs.get(predicate.getKey());
        codec.encode(writer, (Object)predicate.getFrom());
        codec.encode(writer, (Object)predicate.getTo());
    }

    private void writeRegexp(StructuredOutput writer, AggregationPredicates.PredicateRegexp predicate) {
        writer.writeString(predicate.getKey());
        writer.writeString(predicate.getRegexp());
    }

    private void writeAnd(StructuredOutput writer, AggregationPredicates.PredicateAnd predicate) {
        for (AggregationPredicate p : predicate.getPredicates()) {
            this.encode(writer, p);
        }
    }

    private void writeOr(StructuredOutput writer, AggregationPredicates.PredicateOr predicate) {
        for (AggregationPredicate p : predicate.getPredicates()) {
            this.encode(writer, p);
        }
    }

    private void writeNot(StructuredOutput writer, AggregationPredicates.PredicateNot predicate) {
        this.encode(writer, predicate.getPredicate());
    }

    public void encode(StructuredOutput writer, AggregationPredicate predicate) {
        if (predicate instanceof AggregationPredicates.PredicateEq) {
            writer.writeObject(() -> this.writeEq(writer, (AggregationPredicates.PredicateEq)predicate));
        } else {
            writer.writeTuple(() -> {
                if (predicate instanceof AggregationPredicates.PredicateNotEq) {
                    writer.writeString(NOT_EQ);
                    this.writeNotEq(writer, (AggregationPredicates.PredicateNotEq)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateGe) {
                    writer.writeString(GE);
                    this.writeGe(writer, (AggregationPredicates.PredicateGe)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateHas) {
                    writer.writeString(HAS);
                    writer.writeString(((AggregationPredicates.PredicateHas)predicate).getKey());
                } else if (predicate instanceof AggregationPredicates.PredicateGt) {
                    writer.writeString(GT);
                    this.writeGt(writer, (AggregationPredicates.PredicateGt)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateLe) {
                    writer.writeString(LE);
                    this.writeLe(writer, (AggregationPredicates.PredicateLe)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateLt) {
                    writer.writeString(LT);
                    this.writeLt(writer, (AggregationPredicates.PredicateLt)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateIn) {
                    writer.writeString(IN);
                    this.writeIn(writer, (AggregationPredicates.PredicateIn)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateBetween) {
                    writer.writeString(BETWEEN);
                    this.writeBetween(writer, (AggregationPredicates.PredicateBetween)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateRegexp) {
                    writer.writeString(REGEXP);
                    this.writeRegexp(writer, (AggregationPredicates.PredicateRegexp)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateAnd) {
                    writer.writeString(AND);
                    this.writeAnd(writer, (AggregationPredicates.PredicateAnd)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateOr) {
                    writer.writeString(OR);
                    this.writeOr(writer, (AggregationPredicates.PredicateOr)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateNot) {
                    writer.writeString(NOT);
                    this.writeNot(writer, (AggregationPredicates.PredicateNot)predicate);
                } else if (predicate instanceof AggregationPredicates.PredicateAlwaysTrue) {
                    writer.writeString(TRUE);
                } else if (predicate instanceof AggregationPredicates.PredicateAlwaysFalse) {
                    writer.writeString(FALSE);
                } else {
                    throw new IllegalArgumentException("Unknown predicate type");
                }
            });
        }
    }

    private AggregationPredicate readObjectWithAlgebraOfSetsOperator(StructuredInput reader) throws ParseException {
        ArrayList<AggregationPredicate> predicates = new ArrayList<AggregationPredicate>();
        while (reader.hasNext()) {
            AggregationPredicate comparisonPredicate;
            String[] fieldWithOperator = reader.readKey().split(SPACES);
            String field = fieldWithOperator[0];
            String operator = fieldWithOperator.length == 1 ? EMPTY_STRING : fieldWithOperator[1];
            StructuredCodec<?> codec = this.attributeCodecs.get(field);
            if (codec == null) {
                throw new ParseException("Could not parse: " + field);
            }
            Object value = codec.decode(reader);
            switch (operator) {
                case "": 
                case "=": {
                    comparisonPredicate = AggregationPredicates.eq((String)field, (Object)value);
                    break;
                }
                case "<>": {
                    comparisonPredicate = AggregationPredicates.notEq((String)field, (Object)value);
                    break;
                }
                case ">=": {
                    comparisonPredicate = AggregationPredicates.ge((String)field, (Comparable)((Comparable)value));
                    break;
                }
                case ">": {
                    comparisonPredicate = AggregationPredicates.gt((String)field, (Comparable)((Comparable)value));
                    break;
                }
                case "<=": {
                    comparisonPredicate = AggregationPredicates.le((String)field, (Comparable)((Comparable)value));
                    break;
                }
                case "<": {
                    comparisonPredicate = AggregationPredicates.lt((String)field, (Comparable)((Comparable)value));
                    break;
                }
                case "IN": {
                    comparisonPredicate = AggregationPredicates.in((String)field, (Collection)((Set)value));
                    break;
                }
                default: {
                    throw new ParseException("Could not read predicate");
                }
            }
            predicates.add(comparisonPredicate);
        }
        return predicates.size() == 1 ? (AggregationPredicate)predicates.get(0) : AggregationPredicates.and(predicates);
    }

    private <T> StructuredCodec<T> getAttributeCodec(String attribute) throws ParseException {
        StructuredCodec<?> codec = this.attributeCodecs.get(attribute);
        if (codec == null) {
            throw new ParseException("Unknown attribute: " + attribute);
        }
        return codec;
    }

    private AggregationPredicate readEq(StructuredInput reader) throws ParseException {
        String attribute = reader.readString();
        StructuredCodec codec = this.getAttributeCodec(attribute);
        Object value = codec.decode(reader);
        return AggregationPredicates.eq((String)attribute, (Object)value);
    }

    private AggregationPredicate readNotEq(StructuredInput reader) throws ParseException {
        String attribute = reader.readString();
        StructuredCodec codec = this.getAttributeCodec(attribute);
        Object value = codec.decode(reader);
        return AggregationPredicates.notEq((String)attribute, (Object)value);
    }

    private AggregationPredicate readGe(StructuredInput reader) throws ParseException {
        String attribute = reader.readString();
        StructuredCodec codec = this.getAttributeCodec(attribute);
        Comparable value = (Comparable)codec.decode(reader);
        return AggregationPredicates.ge((String)attribute, (Comparable)value);
    }

    private AggregationPredicate readGt(StructuredInput reader) throws ParseException {
        String attribute = reader.readString();
        StructuredCodec codec = this.getAttributeCodec(attribute);
        Comparable value = (Comparable)codec.decode(reader);
        return AggregationPredicates.gt((String)attribute, (Comparable)value);
    }

    private AggregationPredicate readLe(StructuredInput reader) throws ParseException {
        String attribute = reader.readString();
        StructuredCodec codec = this.getAttributeCodec(attribute);
        Comparable value = (Comparable)codec.decode(reader);
        return AggregationPredicates.le((String)attribute, (Comparable)value);
    }

    private AggregationPredicate readLt(StructuredInput reader) throws ParseException {
        String attribute = reader.readString();
        StructuredCodec codec = this.getAttributeCodec(attribute);
        Comparable value = (Comparable)codec.decode(reader);
        return AggregationPredicates.lt((String)attribute, (Comparable)value);
    }

    private AggregationPredicate readIn(StructuredInput reader) throws ParseException {
        String attribute = reader.readString();
        StructuredCodec codec = this.getAttributeCodec(attribute);
        LinkedHashSet<Object> values = new LinkedHashSet<Object>();
        while (reader.hasNext()) {
            Object value = codec.decode(reader);
            values.add(value);
        }
        return AggregationPredicates.in((String)attribute, values);
    }

    private AggregationPredicate readBetween(StructuredInput reader) throws ParseException {
        String attribute = reader.readString();
        StructuredCodec codec = this.getAttributeCodec(attribute);
        Comparable from = (Comparable)codec.decode(reader);
        Comparable to = (Comparable)codec.decode(reader);
        return AggregationPredicates.between((String)attribute, (Comparable)from, (Comparable)to);
    }

    private AggregationPredicate readRegexp(StructuredInput reader) throws ParseException {
        Pattern pattern;
        String attribute = reader.readString();
        String regexp = reader.readString();
        try {
            pattern = Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            throw new ParseException("Malformed regexp", (Throwable)e);
        }
        return AggregationPredicates.regexp((String)attribute, (Pattern)pattern);
    }

    private AggregationPredicate readAnd(StructuredInput reader) throws ParseException {
        ArrayList<AggregationPredicate> predicates = new ArrayList<AggregationPredicate>();
        while (reader.hasNext()) {
            AggregationPredicate predicate = this.decode(reader);
            predicates.add(predicate);
        }
        return AggregationPredicates.and(predicates);
    }

    private AggregationPredicate readOr(StructuredInput reader) throws ParseException {
        ArrayList<AggregationPredicate> predicates = new ArrayList<AggregationPredicate>();
        while (reader.hasNext()) {
            AggregationPredicate predicate = this.decode(reader);
            predicates.add(predicate);
        }
        return AggregationPredicates.or(predicates);
    }

    private AggregationPredicate readNot(StructuredInput reader) throws ParseException {
        AggregationPredicate predicate = this.decode(reader);
        return AggregationPredicates.not((AggregationPredicate)predicate);
    }

    public AggregationPredicate decode(StructuredInput reader) throws ParseException {
        if (reader.getNext().contains(StructuredInput.Token.OBJECT)) {
            return (AggregationPredicate)reader.readObject(this::readObjectWithAlgebraOfSetsOperator);
        }
        return (AggregationPredicate)reader.readTuple(in -> {
            String type;
            switch (type = in.readString()) {
                case "eq": {
                    return this.readEq(in);
                }
                case "notEq": {
                    return this.readNotEq(in);
                }
                case "ge": {
                    return this.readGe(in);
                }
                case "gt": {
                    return this.readGt(in);
                }
                case "le": {
                    return this.readLe(in);
                }
                case "lt": {
                    return this.readLt(in);
                }
                case "in": {
                    return this.readIn(in);
                }
                case "between": {
                    return this.readBetween(in);
                }
                case "regexp": {
                    return this.readRegexp(in);
                }
                case "and": {
                    return this.readAnd(in);
                }
                case "or": {
                    return this.readOr(in);
                }
                case "not": {
                    return this.readNot(in);
                }
                case "true": {
                    return AggregationPredicates.alwaysTrue();
                }
                case "false": {
                    return AggregationPredicates.alwaysFalse();
                }
            }
            throw new ParseException("Unknown predicate type " + type);
        });
    }
}

