/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube;

import io.activej.common.collection.CollectionUtils;
import io.activej.cube.ReportType;
import io.activej.record.Record;
import io.activej.record.RecordScheme;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class QueryResult {
    private final RecordScheme recordScheme;
    private final List<String> attributes;
    private final List<String> measures;
    private final List<String> sortedBy;
    private final List<Record> records;
    private final Record totals;
    private final int totalCount;
    private final Map<String, Object> filterAttributes;
    private final ReportType reportType;

    private QueryResult(RecordScheme recordScheme, List<Record> records, Record totals, int totalCount, List<String> attributes, List<String> measures, List<String> sortedBy, Map<String, Object> filterAttributes, ReportType reportType) {
        this.recordScheme = recordScheme;
        this.records = records;
        this.totals = totals;
        this.totalCount = totalCount;
        this.attributes = attributes;
        this.measures = measures;
        this.sortedBy = sortedBy;
        this.filterAttributes = filterAttributes;
        this.reportType = reportType;
    }

    public static QueryResult create(RecordScheme recordScheme, List<String> attributes, List<String> measures, List<String> sortedBy, List<Record> records, Record totals, int totalCount, Map<String, Object> filterAttributes, ReportType reportType) {
        return new QueryResult(recordScheme, records, totals, totalCount, attributes, measures, sortedBy, filterAttributes, reportType);
    }

    public static QueryResult createForMetadata(RecordScheme recordScheme, List<String> attributes, List<String> measures) {
        return QueryResult.create(recordScheme, attributes, measures, Collections.emptyList(), Collections.emptyList(), recordScheme.record(), 0, Collections.emptyMap(), ReportType.METADATA);
    }

    public static QueryResult createForData(RecordScheme recordScheme, List<Record> records, List<String> attributes, List<String> measures, List<String> sortedBy, Map<String, Object> filterAttributes) {
        return QueryResult.create(recordScheme, attributes, measures, sortedBy, records, recordScheme.record(), 0, filterAttributes, ReportType.DATA);
    }

    public static QueryResult createForDataWithTotals(RecordScheme recordScheme, List<Record> records, Record totals, int totalCount, List<String> attributes, List<String> measures, List<String> sortedBy, Map<String, Object> filterAttributes) {
        return QueryResult.create(recordScheme, attributes, measures, sortedBy, records, totals, totalCount, filterAttributes, ReportType.DATA_WITH_TOTALS);
    }

    public RecordScheme getRecordScheme() {
        return this.recordScheme;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public List<String> getMeasures() {
        return this.measures;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public Record getTotals() {
        return this.totals;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public Map<String, Object> getFilterAttributes() {
        return this.filterAttributes;
    }

    public List<String> getSortedBy() {
        return this.sortedBy;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public String toString() {
        return "QueryResult{attributes=" + this.attributes + ", measures=" + this.measures + ", records=" + CollectionUtils.toLimitedString(this.records, (int)5) + ", totals=" + this.totals + ", count=" + this.totalCount + ", sortedBy=" + this.sortedBy + '}';
    }
}

