/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.http;

import io.activej.aggregation.AggregationPredicate;
import io.activej.aggregation.QueryException;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.codec.StructuredCodec;
import io.activej.codec.json.JsonUtils;
import io.activej.codec.registry.CodecFactory;
import io.activej.codegen.DefiningClassLoader;
import io.activej.common.exception.parse.ParseException;
import io.activej.common.time.Stopwatch;
import io.activej.cube.CubeQuery;
import io.activej.cube.ICube;
import io.activej.cube.QueryResult;
import io.activej.cube.http.AggregationPredicateCodec;
import io.activej.cube.http.QueryResultCodec;
import io.activej.cube.http.Utils;
import io.activej.eventloop.Eventloop;
import io.activej.http.AsyncServlet;
import io.activej.http.AsyncServletWithStats;
import io.activej.http.ContentType;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMethod;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.MediaType;
import io.activej.http.MediaTypes;
import io.activej.http.RoutingServlet;
import io.activej.promise.Promise;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportingServiceServlet
extends AsyncServletWithStats {
    private static final Logger logger = LoggerFactory.getLogger(ReportingServiceServlet.class);
    private final ICube cube;
    private final CodecFactory mapping;
    private StructuredCodec<QueryResult> queryResultCodec;
    private StructuredCodec<AggregationPredicate> aggregationPredicateCodec;
    private DefiningClassLoader classLoader = DefiningClassLoader.create();
    private static final Pattern SPLITTER = Pattern.compile(",");

    private ReportingServiceServlet(Eventloop eventloop, ICube cube, CodecFactory mapping) {
        super(eventloop);
        this.cube = cube;
        this.mapping = mapping;
    }

    public static ReportingServiceServlet create(Eventloop eventloop, ICube cube, CodecFactory mapping) {
        return new ReportingServiceServlet(eventloop, cube, mapping);
    }

    public static ReportingServiceServlet create(Eventloop eventloop, ICube cube) {
        return new ReportingServiceServlet(eventloop, cube, Utils.CUBE_TYPES);
    }

    public static RoutingServlet createRootServlet(Eventloop eventloop, ICube cube) {
        return ReportingServiceServlet.createRootServlet(ReportingServiceServlet.create(eventloop, cube));
    }

    public static RoutingServlet createRootServlet(ReportingServiceServlet reportingServiceServlet) {
        return RoutingServlet.create().map(HttpMethod.GET, "/", (AsyncServlet)reportingServiceServlet);
    }

    public ReportingServiceServlet withClassLoader(DefiningClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    private StructuredCodec<AggregationPredicate> getAggregationPredicateCodec() {
        if (this.aggregationPredicateCodec == null) {
            this.aggregationPredicateCodec = AggregationPredicateCodec.create(this.mapping, this.cube.getAttributeTypes(), this.cube.getMeasureTypes());
        }
        return this.aggregationPredicateCodec;
    }

    private StructuredCodec<QueryResult> getQueryResultCodec() {
        if (this.queryResultCodec == null) {
            this.queryResultCodec = QueryResultCodec.create(this.classLoader, this.mapping, this.cube.getAttributeTypes(), this.cube.getMeasureTypes());
        }
        return this.queryResultCodec;
    }

    @NotNull
    public Promise<HttpResponse> doServe(@NotNull HttpRequest httpRequest) {
        logger.info("Received request: {}", (Object)httpRequest);
        try {
            Stopwatch totalTimeStopwatch = Stopwatch.createStarted();
            CubeQuery cubeQuery = this.parseQuery(httpRequest);
            return this.cube.query(cubeQuery).map(queryResult -> {
                Stopwatch resultProcessingStopwatch = Stopwatch.createStarted();
                String json = JsonUtils.toJson(this.getQueryResultCodec(), (Object)queryResult);
                HttpResponse httpResponse = ReportingServiceServlet.createResponse(json);
                logger.info("Processed request {} ({}) [totalTime={}, jsonConstruction={}]", new Object[]{httpRequest, cubeQuery, totalTimeStopwatch, resultProcessingStopwatch});
                return httpResponse;
            });
        }
        catch (QueryException e) {
            logger.error("Query exception: " + httpRequest, (Throwable)e);
            return Promise.of((Object)ReportingServiceServlet.createErrorResponse(e.getMessage()));
        }
        catch (ParseException e) {
            logger.error("Parse exception: " + httpRequest, (Throwable)e);
            return Promise.of((Object)ReportingServiceServlet.createErrorResponse(e.getMessage()));
        }
    }

    private static HttpResponse createResponse(String body) {
        HttpResponse response = HttpResponse.ok200();
        response.addHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType((ContentType)ContentType.of((MediaType)MediaTypes.JSON, (Charset)StandardCharsets.UTF_8)));
        response.setBody(ByteBufStrings.wrapUtf8((String)body));
        response.addHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        return response;
    }

    private static HttpResponse createErrorResponse(String body) {
        HttpResponse response = HttpResponse.ofCode((int)400);
        response.addHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType((ContentType)ContentType.of((MediaType)MediaTypes.PLAIN_TEXT, (Charset)StandardCharsets.UTF_8)));
        response.setBody(ByteBufStrings.wrapUtf8((String)body));
        response.addHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        return response;
    }

    private static List<String> split(String input) {
        return SPLITTER.splitAsStream(input).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public CubeQuery parseQuery(HttpRequest request) throws ParseException {
        CubeQuery query = CubeQuery.create();
        String parameter = request.getQueryParameter("attributes");
        if (parameter != null) {
            query.withAttributes(ReportingServiceServlet.split(parameter));
        }
        if ((parameter = request.getQueryParameter("measures")) != null) {
            query.withMeasures(ReportingServiceServlet.split(parameter));
        }
        if ((parameter = request.getQueryParameter("where")) != null) {
            query.withWhere((AggregationPredicate)JsonUtils.fromJson(this.getAggregationPredicateCodec(), (String)parameter));
        }
        if ((parameter = request.getQueryParameter("sort")) != null) {
            query.withOrderings(Utils.parseOrderings(parameter));
        }
        if ((parameter = request.getQueryParameter("having")) != null) {
            query.withHaving((AggregationPredicate)JsonUtils.fromJson(this.getAggregationPredicateCodec(), (String)parameter));
        }
        if ((parameter = request.getQueryParameter("limit")) != null) {
            query.withLimit(Utils.parseNonNegativeInteger(parameter));
        }
        if ((parameter = request.getQueryParameter("offset")) != null) {
            query.withOffset(Utils.parseNonNegativeInteger(parameter));
        }
        if ((parameter = request.getQueryParameter("reportType")) != null) {
            query.withReportType(Utils.parseReportType(parameter));
        }
        return query;
    }
}

