/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.ot;

import io.activej.aggregation.Aggregation;
import io.activej.aggregation.ot.AggregationDiff;
import io.activej.aggregation.ot.AggregationDiffCodec;
import io.activej.aggregation.ot.AggregationStructure;
import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredInput;
import io.activej.codec.StructuredOutput;
import io.activej.common.exception.parse.ParseException;
import io.activej.cube.Cube;
import io.activej.cube.ot.CubeDiff;
import java.util.LinkedHashMap;
import java.util.Map;

public class CubeDiffCodec
implements StructuredCodec<CubeDiff> {
    private final Map<String, AggregationDiffCodec> aggregationDiffCodecs;

    private CubeDiffCodec(Map<String, AggregationDiffCodec> aggregationDiffCodecs) {
        this.aggregationDiffCodecs = aggregationDiffCodecs;
    }

    public static CubeDiffCodec create(Cube cube) {
        LinkedHashMap<String, AggregationDiffCodec> aggregationDiffCodecs = new LinkedHashMap<String, AggregationDiffCodec>();
        for (String aggregationId : cube.getAggregationIds()) {
            Aggregation aggregation = cube.getAggregation(aggregationId);
            AggregationDiffCodec aggregationDiffCodec = AggregationDiffCodec.create((AggregationStructure)aggregation.getStructure());
            aggregationDiffCodecs.put(aggregationId, aggregationDiffCodec);
        }
        return new CubeDiffCodec(aggregationDiffCodecs);
    }

    public void encode(StructuredOutput out, CubeDiff cubeDiff) {
        out.writeObject(() -> {
            for (Map.Entry<String, AggregationDiffCodec> entry : this.aggregationDiffCodecs.entrySet()) {
                AggregationDiff aggregationDiff = cubeDiff.get(entry.getKey());
                if (aggregationDiff == null) continue;
                out.writeKey(entry.getKey());
                entry.getValue().encode(out, aggregationDiff);
            }
        });
    }

    public CubeDiff decode(StructuredInput in) throws ParseException {
        return (CubeDiff)in.readObject($ -> {
            LinkedHashMap<String, AggregationDiff> map = new LinkedHashMap<String, AggregationDiff>();
            while (in.hasNext()) {
                String aggregation = in.readKey();
                AggregationDiffCodec aggregationDiffCodec = this.aggregationDiffCodecs.get(aggregation);
                if (aggregationDiffCodec == null) {
                    throw new ParseException("Unknown aggregation: " + aggregation);
                }
                AggregationDiff aggregationDiff = aggregationDiffCodec.decode(in);
                map.put(aggregation, aggregationDiff);
            }
            return CubeDiff.of(map);
        });
    }
}

