/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.ot;

import io.activej.aggregation.ot.AggregationDiff;
import io.activej.aggregation.ot.AggregationOT;
import io.activej.common.collection.CollectionUtils;
import io.activej.cube.ot.CubeDiff;
import io.activej.ot.TransformResult;
import io.activej.ot.exceptions.OTTransformException;
import io.activej.ot.system.OTSystem;
import io.activej.ot.system.OTSystemImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class CubeOT {
    public static OTSystem<CubeDiff> createCubeOT() {
        OTSystem aggregationOTSystem = AggregationOT.createAggregationOT();
        return OTSystemImpl.create().withTransformFunction(CubeDiff.class, CubeDiff.class, (left, right) -> {
            LinkedHashMap<String, AggregationDiff> newOpsLeft = new LinkedHashMap<String, AggregationDiff>();
            LinkedHashMap<String, AggregationDiff> newOpsRight = new LinkedHashMap<String, AggregationDiff>();
            for (String aggregation : CollectionUtils.union(left.keySet(), right.keySet())) {
                TransformResult transformed;
                AggregationDiff leftOps = left.get(aggregation);
                AggregationDiff rightOps = right.get(aggregation);
                if (leftOps == null) {
                    leftOps = AggregationDiff.empty();
                }
                if (rightOps == null) {
                    rightOps = AggregationDiff.empty();
                }
                if ((transformed = aggregationOTSystem.transform((Object)leftOps, (Object)rightOps)).hasConflict()) {
                    return TransformResult.conflict((TransformResult.ConflictResolution)transformed.resolution);
                }
                if (transformed.left.size() > 1) {
                    throw new OTTransformException("Left transformation result has more than one aggregation diff");
                }
                if (transformed.right.size() > 1) {
                    throw new OTTransformException("Right transformation result has more than one aggregation diff");
                }
                if (!transformed.left.isEmpty()) {
                    newOpsLeft.put(aggregation, (AggregationDiff)transformed.left.get(0));
                }
                if (transformed.right.isEmpty()) continue;
                newOpsRight.put(aggregation, (AggregationDiff)transformed.right.get(0));
            }
            return TransformResult.of((Object)CubeDiff.of(newOpsLeft), (Object)CubeDiff.of(newOpsRight));
        }).withEmptyPredicate(CubeDiff.class, CubeDiff::isEmpty).withInvertFunction(CubeDiff.class, commit -> Collections.singletonList(commit.inverse())).withSquashFunction(CubeDiff.class, CubeDiff.class, (commit1, commit2) -> {
            LinkedHashMap<String, AggregationDiff> newOps = new LinkedHashMap<String, AggregationDiff>();
            for (String aggregation : CollectionUtils.union(commit1.keySet(), commit2.keySet())) {
                AggregationDiff ops1 = commit1.get(aggregation);
                AggregationDiff ops2 = commit2.get(aggregation);
                if (ops1 == null) {
                    newOps.put(aggregation, ops2);
                    continue;
                }
                if (ops2 == null) {
                    newOps.put(aggregation, ops1);
                    continue;
                }
                ArrayList<AggregationDiff> ops = new ArrayList<AggregationDiff>();
                ops.add(ops1);
                ops.add(ops2);
                List simplified = aggregationOTSystem.squash(ops);
                if (simplified.isEmpty()) continue;
                if (simplified.size() > 1) {
                    throw new AssertionError();
                }
                newOps.put(aggregation, (AggregationDiff)simplified.get(0));
            }
            return CubeDiff.of(newOps);
        });
    }
}

