/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube;

import io.activej.aggregation.measure.Measure;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.util.Primitives;
import io.activej.cube.ComputedMeasure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ComputedMeasures {
    public static ComputedMeasure value(Object value) {
        return new ComputedMeasureValue(value);
    }

    public static ComputedMeasure measure(String measureId) {
        return new ComputedMeasureMeasure(measureId);
    }

    public static ComputedMeasure add(final ComputedMeasure measure1, final ComputedMeasure measure2) {
        return new AbstractArithmeticMeasure(new ComputedMeasure[]{measure1, measure2}){

            @Override
            public Expression getExpression(Expression record, Map<String, Measure> storedMeasures) {
                return E.add((Expression)measure1.getExpression(record, storedMeasures), (Expression)measure2.getExpression(record, storedMeasures));
            }
        };
    }

    public static ComputedMeasure sub(final ComputedMeasure measure1, final ComputedMeasure measure2) {
        return new AbstractArithmeticMeasure(new ComputedMeasure[]{measure1, measure2}){

            @Override
            public Expression getExpression(Expression record, Map<String, Measure> storedMeasures) {
                return E.sub((Expression)measure1.getExpression(record, storedMeasures), (Expression)measure2.getExpression(record, storedMeasures));
            }
        };
    }

    public static ComputedMeasure div(final ComputedMeasure measure1, final ComputedMeasure measure2) {
        return new AbstractComputedMeasure(new ComputedMeasure[]{measure1, measure2}){

            @Override
            public Class<?> getType(Map<String, Measure> storedMeasures) {
                return Double.TYPE;
            }

            @Override
            public Expression getExpression(Expression record, Map<String, Measure> storedMeasures) {
                Expression value2 = E.cast((Expression)measure2.getExpression(record, storedMeasures), Double.TYPE);
                return E.ifThenElse((Expression)E.cmpNe((Expression)value2, (Expression)E.value((Object)0.0)), (Expression)E.div((Expression)measure1.getExpression(record, storedMeasures), (Expression)value2), (Expression)E.value((Object)0.0));
            }
        };
    }

    public static ComputedMeasure mul(final ComputedMeasure measure1, final ComputedMeasure measure2) {
        return new AbstractArithmeticMeasure(new ComputedMeasure[]{measure1, measure2}){

            @Override
            public Expression getExpression(Expression record, Map<String, Measure> storedMeasures) {
                return E.mul((Expression)measure1.getExpression(record, storedMeasures), (Expression)measure2.getExpression(record, storedMeasures));
            }
        };
    }

    public static ComputedMeasure sqrt(final ComputedMeasure measure) {
        return new AbstractComputedMeasure(new ComputedMeasure[]{measure}){

            @Override
            public Class<?> getType(Map<String, Measure> storedMeasures) {
                return Double.TYPE;
            }

            @Override
            public Expression getExpression(Expression record, Map<String, Measure> storedMeasures) {
                return E.let((Expression)E.cast((Expression)measure.getExpression(record, storedMeasures), Double.TYPE), value -> E.ifThenElse((Expression)E.cmpLe((Expression)value, (Expression)E.value((Object)0.0)), (Expression)E.value((Object)0.0), (Expression)E.staticCall(Math.class, (String)"sqrt", (Expression[])new Expression[]{value})));
            }
        };
    }

    public static ComputedMeasure sqr(final ComputedMeasure measure) {
        return new AbstractComputedMeasure(new ComputedMeasure[]{measure}){

            @Override
            public Class<?> getType(Map<String, Measure> storedMeasures) {
                return Double.TYPE;
            }

            @Override
            public Expression getExpression(Expression record, Map<String, Measure> storedMeasures) {
                return E.let((Expression)E.cast((Expression)measure.getExpression(record, storedMeasures), Double.TYPE), value -> E.mul((Expression)value, (Expression)value));
            }
        };
    }

    public static ComputedMeasure stddev(ComputedMeasure sum, ComputedMeasure sumOfSquares, ComputedMeasure count) {
        return ComputedMeasures.sqrt(ComputedMeasures.variance(sum, sumOfSquares, count));
    }

    public static ComputedMeasure variance(ComputedMeasure sum, ComputedMeasure sumOfSquares, ComputedMeasure count) {
        return ComputedMeasures.sub(ComputedMeasures.div(sumOfSquares, count), ComputedMeasures.sqr(ComputedMeasures.div(sum, count)));
    }

    public static ComputedMeasure percent(ComputedMeasure measure) {
        return ComputedMeasures.mul(measure, ComputedMeasures.value(100));
    }

    public static ComputedMeasure percent(ComputedMeasure numerator, ComputedMeasure denominator) {
        return ComputedMeasures.mul(ComputedMeasures.div(numerator, denominator), ComputedMeasures.value(100));
    }

    private static final class ComputedMeasureValue
    implements ComputedMeasure {
        private final Object value;

        public ComputedMeasureValue(Object value) {
            this.value = value;
        }

        @Override
        public Class<?> getType(Map<String, Measure> storedMeasures) {
            return Primitives.unwrap(this.value.getClass());
        }

        @Override
        public Expression getExpression(Expression record, Map<String, Measure> storedMeasures) {
            return E.value((Object)this.value);
        }

        @Override
        public Set<String> getMeasureDependencies() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComputedMeasureValue other = (ComputedMeasureValue)o;
            return Objects.equals(this.value, other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static final class ComputedMeasureMeasure
    implements ComputedMeasure {
        private final String measureId;

        public ComputedMeasureMeasure(String measureId) {
            this.measureId = measureId;
        }

        @Override
        public Class<?> getType(Map<String, Measure> storedMeasures) {
            return (Class)storedMeasures.get(this.measureId).getFieldType().getDataType();
        }

        @Override
        public Expression getExpression(Expression record, Map<String, Measure> storedMeasures) {
            return storedMeasures.get(this.measureId).valueOfAccumulator((Expression)E.property((Expression)record, (String)this.measureId));
        }

        @Override
        public Set<String> getMeasureDependencies() {
            return Collections.singleton(this.measureId);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComputedMeasureMeasure other = (ComputedMeasureMeasure)o;
            return this.measureId.equals(other.measureId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.measureId);
        }
    }

    private static abstract class AbstractArithmeticMeasure
    extends AbstractComputedMeasure {
        public AbstractArithmeticMeasure(ComputedMeasure ... dependencies) {
            super(dependencies);
        }

        @Override
        public final Class<?> getType(Map<String, Measure> storedMeasures) {
            ArrayList types = new ArrayList();
            for (ComputedMeasure dependency : this.dependencies) {
                types.add(dependency.getType(storedMeasures));
            }
            return E.unifyArithmeticTypes(types);
        }
    }

    public static abstract class AbstractComputedMeasure
    implements ComputedMeasure {
        protected final Set<ComputedMeasure> dependencies;

        public AbstractComputedMeasure(ComputedMeasure ... dependencies) {
            this.dependencies = new LinkedHashSet<ComputedMeasure>(Arrays.asList(dependencies));
        }

        @Override
        @Nullable
        public Class<?> getType(Map<String, Measure> storedMeasures) {
            return null;
        }

        @Override
        public final Set<String> getMeasureDependencies() {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (ComputedMeasure dependency : this.dependencies) {
                result.addAll(dependency.getMeasureDependencies());
            }
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractComputedMeasure other = (AbstractComputedMeasure)o;
            return this.dependencies.equals(other.dependencies);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.dependencies);
        }
    }

    private static final class E
    extends Expressions {
        private E() {
        }
    }
}

